/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.Navbar;
import org.gwtbootstrap3.client.ui.NavbarBrand;
import org.gwtbootstrap3.client.ui.NavbarCollapse;
import org.gwtbootstrap3.client.ui.NavbarHeader;
import org.gwtbootstrap3.client.ui.NavbarNav;
import org.gwtbootstrap3.client.ui.base.AbstractListItem;
import org.jboss.errai.ioc.client.container.IOCResolutionException;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.views.pfly.menu.Bs3Menus;
import org.uberfire.client.views.pfly.menu.HasMenuItems;
import org.uberfire.client.views.pfly.menu.MainBrand;
import org.uberfire.client.views.pfly.menu.UserMenu;
import org.uberfire.client.views.pfly.menu.UtilityNavbar;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarPresenter;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
public class WorkbenchMenuBarView
extends Composite
implements WorkbenchMenuBarPresenter.View {
    @Inject
    private AuthorizationManager authzManager;
    @Inject
    private User identity;
    @Inject
    @MainBrand
    private Instance<NavbarBrand> menuBarBrand;
    @Inject
    private UserMenu userMenu;
    private final NavbarNav primaryNavBar = new NavbarNav();
    private final UtilityNavbar utilityNavbar = new UtilityNavbar();

    @PostConstruct
    private void setup() {
        Navbar root = new Navbar();
        root.addStyleName("navbar-pf");
        try {
            NavbarHeader headerContainer = new NavbarHeader();
            headerContainer.add((Widget)this.menuBarBrand.get());
            root.add((Widget)headerContainer);
        }
        catch (IOCResolutionException e) {
            // empty catch block
        }
        NavbarCollapse collapsibleContainer = new NavbarCollapse();
        this.utilityNavbar.add((Widget)this.userMenu);
        this.primaryNavBar.addStyleName("navbar-primary");
        collapsibleContainer.add((Widget)this.utilityNavbar);
        collapsibleContainer.add((Widget)this.primaryNavBar);
        root.add((Widget)collapsibleContainer);
        this.initWidget((Widget)root);
    }

    public void addMenuItems(Menus menus) {
        HasMenuItems topLevelContainer = new HasMenuItems(){

            public Widget asWidget() {
                return WorkbenchMenuBarView.this;
            }

            @Override
            public int getMenuItemCount() {
                return WorkbenchMenuBarView.this.primaryNavBar.getWidgetCount() + WorkbenchMenuBarView.this.utilityNavbar.getWidgetCount() + WorkbenchMenuBarView.this.userMenu.getWidgetCount();
            }

            @Override
            public void addMenuItem(MenuPosition position, AbstractListItem menuContent) {
                if (position == null) {
                    position = MenuPosition.CENTER;
                }
                switch (position) {
                    case LEFT: {
                        WorkbenchMenuBarView.this.primaryNavBar.add((Widget)menuContent);
                        break;
                    }
                    case CENTER: {
                        WorkbenchMenuBarView.this.utilityNavbar.insert((Widget)menuContent, WorkbenchMenuBarView.this.utilityNavbar.getWidgetCount() - 1);
                        break;
                    }
                    case RIGHT: {
                        WorkbenchMenuBarView.this.userMenu.getMenu().add((Widget)menuContent);
                    }
                }
            }
        };
        Bs3Menus.constructMenuView(menus, this.authzManager, this.identity, topLevelContainer);
    }

    public void clear() {
        this.userMenu.clear();
        this.primaryNavBar.clear();
        this.utilityNavbar.clear();
        this.utilityNavbar.add((Widget)this.userMenu);
    }
}

