/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.modal;

import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.gwtbootstrap3.client.shared.event.ModalHiddenEvent;
import org.gwtbootstrap3.client.shared.event.ModalHiddenHandler;
import org.gwtbootstrap3.client.shared.event.ModalShownEvent;
import org.gwtbootstrap3.client.shared.event.ModalShownHandler;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;
import org.jboss.errai.ui.shared.api.annotations.DataField;
import org.jboss.errai.ui.shared.api.annotations.Templated;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

@Templated
public class Bs3Modal
extends Composite {
    @Inject
    @DataField
    private Modal modal;
    @Inject
    @DataField(value="modal-body")
    private ModalBody body;
    @Inject
    @DataField(value="modal-footer")
    private ModalFooter footer;
    @Inject
    @DataField(value="modal-ok-button")
    private Button okButton;
    boolean hasBeenShown;

    @PostConstruct
    void setup() {
        this.modal.setDataBackdrop(ModalBackdrop.STATIC);
    }

    public void show(final Command afterShown, final Command afterClosed) {
        if (this.hasBeenShown) {
            throw new IllegalStateException("This modal has already been shown. Create a new instance if you want to show another modal.");
        }
        PortablePreconditions.checkNotNull((String)"afterShown", (Object)afterShown);
        PortablePreconditions.checkNotNull((String)"afterClosed", (Object)afterClosed);
        this.modal.addShownHandler(new ModalShownHandler(){

            public void onShown(ModalShownEvent showEvent) {
                if (afterShown != null) {
                    afterShown.execute();
                }
            }
        });
        this.modal.addHiddenHandler(new ModalHiddenHandler(){

            public void onHidden(ModalHiddenEvent hiddenEvent) {
                if (afterClosed != null) {
                    afterClosed.execute();
                }
            }
        });
        this.modal.show();
    }

    public void hide() {
        this.modal.hide();
    }

    public void setContent(IsWidget content) {
        this.body.clear();
        this.body.add(content);
    }

    public void setFooterContent(IsWidget content) {
        this.footer.clear();
        this.footer.add(content);
    }

    public void setBodyHeight(int height) {
        this.body.setHeight(height + "px");
    }
}

