/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.tab;

import com.google.gwt.user.client.ui.Widget;
import org.gwtbootstrap3.client.ui.TabListItem;
import org.gwtbootstrap3.client.ui.TabPane;
import org.gwtbootstrap3.client.ui.base.HasActive;

public class TabPanelEntry
implements HasActive {
    private String title;
    private final DropDownTabListItem tab;
    private final TabPane contentPane;
    private final Widget contents;

    public TabPanelEntry(String title, Widget contents) {
        this.title = title;
        this.tab = new DropDownTabListItem(title);
        this.contents = contents;
        this.contentPane = new TabPane();
        this.contentPane.add(contents);
        this.tab.setDataTargetWidget((Widget)this.contentPane);
    }

    public DropDownTabListItem getTabWidget() {
        return this.tab;
    }

    public Widget getContents() {
        return this.contents;
    }

    public TabPane getContentPane() {
        return this.contentPane;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
        this.tab.setText(title);
    }

    public void setInDropdown(boolean inDropdown) {
        this.tab.setInDropdown(inDropdown);
    }

    public boolean isActive() {
        return this.tab.isActive();
    }

    public void setActive(boolean b) {
        this.tab.setActive(b);
    }

    public void showTab() {
        this.tab.showTab(false);
    }

    public String toString() {
        return "TabPanelEntry \"" + this.title + "\"";
    }

    public static class DropDownTabListItem
    extends TabListItem {
        public DropDownTabListItem(String label) {
            super(label);
            this.addStyleName("uf-dropdown-tab-list-item");
        }

        public void setInDropdown(boolean inDropdown) {
            this.anchor.setTabIndex(inDropdown ? -1 : 0);
        }

        public void addToAnchor(Widget w) {
            this.anchor.add(w);
        }
    }
}

