/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.bs2.notifications;

import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.Dependent;
import org.uberfire.client.views.bs2.notifications.NotificationPopupView;
import org.uberfire.client.workbench.widgets.animations.LinearFadeOutAnimation;
import org.uberfire.client.workbench.widgets.notifications.NotificationManager;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.workbench.events.NotificationEvent;

@Dependent
public class NotificationPopupsManagerView
implements NotificationManager.View {
    private boolean removing = false;
    private final int SPACING = 48;
    private int initialSpacing = 48;
    private IsWidget container;
    private final List<PopupHandle> activeNotifications = new ArrayList<PopupHandle>();
    private final List<PopupHandle> pendingRemovals = new ArrayList<PopupHandle>();

    public void setContainer(IsWidget container) {
        this.container = (IsWidget)PortablePreconditions.checkNotNull((String)"container", (Object)container);
    }

    public void setInitialSpacing(int spacing) {
        this.initialSpacing = spacing;
    }

    public NotificationManager.NotificationPopupHandle show(NotificationEvent event, Command hideCommand) {
        if (this.container == null) {
            throw new IllegalStateException("The setContainer() method hasn't been called!");
        }
        NotificationPopupView view = new NotificationPopupView();
        PopupHandle popupHandle = new PopupHandle(view, event);
        this.activeNotifications.add(popupHandle);
        int size = this.activeNotifications.size();
        int topMargin = size == 1 ? this.initialSpacing : size * 48 - (48 - this.initialSpacing);
        view.setPopupPosition(this.container.asWidget().getAbsoluteLeft() + this.getMargin(), this.container.asWidget().getAbsoluteTop() + topMargin);
        view.setNotification(event.getNotification());
        view.setType(event.getType());
        view.setNotificationWidth(this.getWidth() + "px");
        view.show(hideCommand);
        return popupHandle;
    }

    public void hide(final NotificationManager.NotificationPopupHandle handle) {
        if (this.container == null) {
            throw new IllegalStateException("The setContainer() method hasn't been called!");
        }
        final int removingIndex = this.activeNotifications.indexOf(handle);
        if (removingIndex == -1) {
            return;
        }
        if (this.removing) {
            this.pendingRemovals.add((PopupHandle)handle);
            return;
        }
        this.removing = true;
        final NotificationPopupView view = ((PopupHandle)handle).view;
        LinearFadeOutAnimation fadeOutAnimation = new LinearFadeOutAnimation((Widget)view){

            public void onUpdate(double progress) {
                super.onUpdate(progress);
                for (int i = removingIndex; i < NotificationPopupsManagerView.this.activeNotifications.size(); ++i) {
                    NotificationPopupView v = ((PopupHandle)((NotificationPopupsManagerView)NotificationPopupsManagerView.this).activeNotifications.get((int)i)).view;
                    int left = v.getPopupLeft();
                    int top = (int)((double)((i + 1) * 48) - progress * 48.0) - (48 - NotificationPopupsManagerView.this.initialSpacing) + NotificationPopupsManagerView.this.container.asWidget().getAbsoluteTop();
                    v.setPopupPosition(left, top);
                }
            }

            public void onComplete() {
                super.onComplete();
                view.hide();
                NotificationPopupsManagerView.this.activeNotifications.remove(handle);
                NotificationPopupsManagerView.this.removing = false;
                if (NotificationPopupsManagerView.this.pendingRemovals.size() > 0) {
                    PopupHandle popupHandle = (PopupHandle)NotificationPopupsManagerView.this.pendingRemovals.remove(0);
                    NotificationPopupsManagerView.this.hide(popupHandle);
                }
            }
        };
        fadeOutAnimation.run(500);
    }

    public boolean isShowing(NotificationEvent event) {
        for (PopupHandle handle : this.activeNotifications) {
            if (!handle.event.equals((Object)event)) continue;
            return true;
        }
        return false;
    }

    private int getWidth() {
        return (int)((double)this.container.asWidget().getElement().getClientWidth() * 0.8);
    }

    private int getMargin() {
        return (this.container.asWidget().getElement().getClientWidth() - this.getWidth()) / 2;
    }

    private static class PopupHandle
    implements NotificationManager.NotificationPopupHandle {
        final NotificationPopupView view;
        final NotificationEvent event;

        PopupHandle(NotificationPopupView view, NotificationEvent event) {
            this.view = (NotificationPopupView)((Object)PortablePreconditions.checkNotNull((String)"view", (Object)((Object)view)));
            this.event = (NotificationEvent)PortablePreconditions.checkNotNull((String)"event", (Object)event);
        }
    }
}

