/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.api.config.base;

import java.lang.reflect.Method;
import org.apache.deltaspike.core.api.config.ConfigResolver;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ExceptionUtils;

public class TypedConfig<T> {
    protected final String key;
    protected final T defaultValue;
    protected final Class<? extends T> configEntryType;
    protected final Object customTypeConverter;
    protected final Method converterMethod;

    public TypedConfig(String key, T defaultValue) {
        this(key, defaultValue, null, defaultValue != null ? defaultValue.getClass() : null);
    }

    public TypedConfig(String key, T defaultValue, Object customTypeConverter) {
        this(key, defaultValue, customTypeConverter, defaultValue != null ? defaultValue.getClass() : null);
    }

    public TypedConfig(String key, T defaultValue, Class<T> targetType) {
        this(key, defaultValue, null, targetType);
    }

    public TypedConfig(String key, T defaultValue, Object customTypeConverter, Class<T> targetType) {
        if (defaultValue == null && targetType == null) {
            throw new IllegalArgumentException("'null' isn't supported by this helper for the default-value and target-type");
        }
        this.key = key;
        this.defaultValue = defaultValue;
        this.configEntryType = this.getConfigEntryType(targetType, defaultValue);
        this.customTypeConverter = customTypeConverter;
        this.converterMethod = this.getCustomTypeConverterMethod(customTypeConverter);
        this.validateConfigEntryType();
    }

    protected Class<? extends T> getConfigEntryType(Class<T> targetType, T defaultValue) {
        if (targetType != null) {
            return targetType;
        }
        return defaultValue.getClass();
    }

    protected Method getCustomTypeConverterMethod(Object customTypeConverter) {
        Method foundConverterMethod = null;
        if (customTypeConverter != null) {
            for (Method currentMethod : customTypeConverter.getClass().getDeclaredMethods()) {
                if (currentMethod.getParameterTypes().length != 1 || !currentMethod.getParameterTypes()[0].equals(String.class) || !currentMethod.getReturnType().equals(this.configEntryType)) continue;
                foundConverterMethod = currentMethod;
                break;
            }
        }
        return foundConverterMethod;
    }

    protected void validateConfigEntryType() {
        if (!(this.converterMethod != null || this.configEntryType.equals(String.class) || this.configEntryType.equals(Class.class) || this.configEntryType.equals(Boolean.class) || this.configEntryType.equals(Integer.class) || this.configEntryType.equals(Float.class))) {
            throw new IllegalArgumentException(this.configEntryType.getName() + " isn't supported out-of-the-box and" + "no valid (custom) type-converter can be found");
        }
    }

    public String getKey() {
        return this.key;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue() {
        String resultString = ConfigResolver.getPropertyValue(this.key, this.defaultValue != null ? this.defaultValue.toString() : null);
        Object result = null;
        if (resultString == null) {
            return null;
        }
        if (String.class.equals(this.configEntryType)) {
            result = resultString;
        } else if (Class.class.equals(this.configEntryType)) {
            result = ClassUtils.tryToLoadClassForName(resultString);
        } else if (Boolean.class.equals(this.configEntryType)) {
            result = Boolean.valueOf(resultString);
        } else if (Integer.class.equals(this.configEntryType)) {
            result = Integer.parseInt(resultString);
        } else if (Float.class.equals(this.configEntryType)) {
            result = Float.valueOf(Float.parseFloat(resultString));
        } else if (this.customTypeConverter != null) {
            try {
                result = this.converterMethod.invoke(this.customTypeConverter, resultString);
            }
            catch (Exception e) {
                throw ExceptionUtils.throwAsRuntimeException(e);
            }
        }
        return (T)result;
    }
}

