/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server;

import java.util.HashSet;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpSession;
import org.jboss.errai.bus.server.annotations.Service;
import org.jboss.errai.bus.server.api.RpcContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.backend.server.util.Paths;
import org.uberfire.backend.vfs.PathFactory;
import org.uberfire.backend.vfs.VFSLockService;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.backend.vfs.impl.LockResult;
import org.uberfire.io.IOService;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.file.DeleteOption;
import org.uberfire.java.nio.file.OpenOption;
import org.uberfire.java.nio.file.Path;
import org.uberfire.rpc.impl.SessionInfoWrapper;

@Service
@ApplicationScoped
public class VFSLockServiceImpl
implements VFSLockService {
    public static final String LOCK_SESSION_ATTRIBUTE_NAME = "uf-locks";
    private static final Logger logger = LoggerFactory.getLogger(VFSLockServiceImpl.class);
    @Inject
    @Named(value="configIO")
    private IOService ioService;
    @Inject
    private SessionInfoWrapper sessionInfo;
    @Inject
    private Event<LockInfo> lockEvent;

    public LockResult acquireLock(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, IOException, UnsupportedOperationException {
        LockResult result;
        String userId = this.sessionInfo.getIdentity().getIdentifier();
        LockInfo lockInfo = this.retrieveLockInfo(path);
        if (lockInfo.isLocked() && !lockInfo.lockedBy().equals(userId)) {
            result = LockResult.failed((LockInfo)lockInfo);
        } else {
            this.ioService.write(Paths.convert(lockInfo.getLock()), userId, new OpenOption[0]);
            this.updateSession(lockInfo, false);
            result = LockResult.acquired((org.uberfire.backend.vfs.Path)path, (String)userId);
            this.lockEvent.fire((Object)result.getLockInfo());
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LockResult releaseLock(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, IOException {
        LockInfo lockInfo = this.retrieveLockInfo(path);
        if (!lockInfo.isLocked()) return LockResult.failed((LockInfo)lockInfo);
        if (!this.sessionInfo.getIdentity().getIdentifier().equals(lockInfo.lockedBy()) && !this.sessionInfo.isAdmin()) {
            logger.error("Client requested to release lock it doesn't hold: " + path.getFileName());
            throw new IOException("Not allowed");
        }
        this.ioService.delete(Paths.convert(lockInfo.getLock()), new DeleteOption[0]);
        this.updateSession(lockInfo, true);
        LockResult result = LockResult.released((org.uberfire.backend.vfs.Path)path);
        this.lockEvent.fire((Object)result.getLockInfo());
        return result;
    }

    public LockInfo retrieveLockInfo(org.uberfire.backend.vfs.Path path) throws IllegalArgumentException, IOException {
        LockInfo result;
        org.uberfire.backend.vfs.Path vfsLock = PathFactory.newLock((org.uberfire.backend.vfs.Path)path);
        Path realLock = Paths.convert(vfsLock);
        if (this.ioService.exists(realLock)) {
            String lockedBy = this.ioService.readAllString(realLock);
            result = new LockInfo(true, lockedBy, path, vfsLock);
        } else {
            result = new LockInfo(false, null, path, vfsLock);
        }
        return result;
    }

    private void updateSession(LockInfo lockInfo, boolean remove) {
        HttpSession session = RpcContext.getHttpSession();
        HashSet<LockInfo> locks = (HashSet<LockInfo>)session.getAttribute(LOCK_SESSION_ATTRIBUTE_NAME);
        if (remove && locks != null) {
            locks.remove(lockInfo);
        } else {
            if (locks == null) {
                locks = new HashSet<LockInfo>();
            }
            locks.add(lockInfo);
            session.setAttribute(LOCK_SESSION_ATTRIBUTE_NAME, locks);
        }
    }
}

