/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.UIObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.vfs.Path;
import org.uberfire.backend.vfs.impl.EditorLockInfo;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.backend.vfs.impl.LockResult;
import org.uberfire.client.mvp.AbstractWorkbenchEditorActivity;
import org.uberfire.client.mvp.EditorLockManager;
import org.uberfire.client.mvp.LockTitleWidgetEvent;
import org.uberfire.client.resources.i18n.WorkbenchConstants;
import org.uberfire.client.workbench.VFSLockServiceProxy;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@Dependent
public class EditorLockManagerImpl
implements EditorLockManager {
    private static final List<String> TAG_CLICK_LOCK_EXCLUSIONS = Arrays.asList("a", "select", "table", "tbody", "tfoot", "td", "tr");
    @Inject
    private VFSLockServiceProxy lockService;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleEvent;
    @Inject
    private Event<EditorLockInfo> editorLockInfoEvent;
    @Inject
    private Event<NotificationEvent> lockNotification;
    @Inject
    private User user;
    private AbstractWorkbenchEditorActivity activity;
    private LockInfo lockInfo = LockInfo.unlocked();
    private HandlerRegistration closeHandler;
    private boolean lockRequestPending;
    private boolean unlockRequestPending;
    private boolean lockSyncComplete;
    private List<Runnable> syncCompleteRunnables = new ArrayList<Runnable>();
    private Timer reloadTimer;

    @Override
    public void init(AbstractWorkbenchEditorActivity activity) {
        this.activity = activity;
        ParameterizedCommand<LockInfo> command = new ParameterizedCommand<LockInfo>(){

            public void execute(LockInfo lockInfo) {
                if (!EditorLockManagerImpl.this.lockRequestPending && !EditorLockManagerImpl.this.unlockRequestPending) {
                    EditorLockManagerImpl.this.updateLockInfo(lockInfo);
                }
            }
        };
        this.lockService.retrieveLockInfo((Path)activity.getPath(), command);
    }

    @Override
    public void onFocus() {
        this.publishJsApi();
        this.fireEditorLockEvent();
    }

    @Override
    public void acquireLockOnDemand() {
        com.google.gwt.user.client.Element element = this.activity.getWidget().asWidget().getElement();
        com.google.gwt.user.client.Event.sinkEvents((Element)element, (int)1921);
        EventListener lockDemandListener = new EventListener(){

            public void onBrowserEvent(com.google.gwt.user.client.Event event) {
                if (EditorLockManagerImpl.this.isLockRequired(event)) {
                    EditorLockManagerImpl.this.acquireLock();
                }
            }
        };
        com.google.gwt.user.client.Event.setEventListener((Element)element, (EventListener)lockDemandListener);
    }

    private void acquireLock() {
        if (this.lockInfo.isLocked()) {
            this.handleLockFailure(this.lockInfo);
        } else if (!this.lockRequestPending) {
            this.lockRequestPending = true;
            ParameterizedCommand<LockResult> command = new ParameterizedCommand<LockResult>(){

                public void execute(LockResult result) {
                    if (result.isSuccess()) {
                        EditorLockManagerImpl.this.updateLockInfo(result.getLockInfo());
                        EditorLockManagerImpl.this.releaseLockOnClose();
                    } else {
                        EditorLockManagerImpl.this.handleLockFailure(result.getLockInfo());
                    }
                    EditorLockManagerImpl.this.lockRequestPending = false;
                }
            };
            this.lockService.acquireLock((Path)this.activity.getPath(), command);
        }
    }

    @Override
    public void releaseLock() {
        Runnable releaseLock = new Runnable(){

            @Override
            public void run() {
                EditorLockManagerImpl.this.releaseLockInternal();
            }
        };
        if (this.lockSyncComplete) {
            releaseLock.run();
        } else {
            this.syncCompleteRunnables.add(releaseLock);
        }
    }

    private void releaseLockInternal() {
        if (this.isLockedByCurrentUser() && !this.unlockRequestPending) {
            this.unlockRequestPending = true;
            ParameterizedCommand<LockResult> command = new ParameterizedCommand<LockResult>(){

                public void execute(LockResult result) {
                    EditorLockManagerImpl.this.updateLockInfo(result.getLockInfo());
                    if (result.isSuccess() && EditorLockManagerImpl.this.closeHandler != null) {
                        EditorLockManagerImpl.this.closeHandler.removeHandler();
                    }
                    EditorLockManagerImpl.this.unlockRequestPending = false;
                }
            };
            this.lockService.releaseLock((Path)this.activity.getPath(), command);
        }
    }

    private void releaseLockOnClose() {
        this.closeHandler = Window.addCloseHandler((CloseHandler)new CloseHandler<Window>(){

            public void onClose(CloseEvent<Window> event) {
                EditorLockManagerImpl.this.releaseLock();
            }
        });
    }

    private void handleLockFailure(LockInfo lockInfo) {
        if (lockInfo != null) {
            this.updateLockInfo(lockInfo);
            this.lockNotification.fire((Object)new NotificationEvent(WorkbenchConstants.INSTANCE.lockedMessage(lockInfo.lockedBy()), NotificationEvent.NotificationType.INFO, true, this.activity.getPlace(), Integer.valueOf(20)));
        } else {
            this.lockNotification.fire((Object)new NotificationEvent(WorkbenchConstants.INSTANCE.lockError(), NotificationEvent.NotificationType.ERROR, true, this.activity.getPlace(), Integer.valueOf(20)));
        }
        if (this.reloadTimer == null) {
            this.reloadTimer = new Timer(){

                public void run() {
                    EditorLockManagerImpl.this.activity.onStartup(EditorLockManagerImpl.this.activity.getPath(), EditorLockManagerImpl.this.activity.getPlace());
                }
            };
        }
        if (!this.reloadTimer.isRunning()) {
            this.reloadTimer.schedule(250);
        }
    }

    private boolean isLockedByCurrentUser() {
        return this.lockInfo.isLocked() && this.lockInfo.lockedBy().equals(this.user.getIdentifier());
    }

    private boolean isLockRequired(com.google.gwt.user.client.Event event) {
        if (this.isLockedByCurrentUser()) {
            return false;
        }
        Element target = Element.as((JavaScriptObject)event.getEventTarget());
        String lockAttribute = this.findLockAttribute(target);
        if (lockAttribute != null && !lockAttribute.isEmpty()) {
            return Boolean.parseBoolean(lockAttribute);
        }
        boolean eventExcluded = event.getTypeInt() == 1 && TAG_CLICK_LOCK_EXCLUSIONS.contains(target.getTagName().toLowerCase());
        return !eventExcluded;
    }

    private String findLockAttribute(Element element) {
        if (element == null) {
            return null;
        }
        String lockAttribute = element.getAttribute("data-uf-lock");
        if (lockAttribute != null && !lockAttribute.isEmpty()) {
            return lockAttribute;
        }
        return this.findLockAttribute(element.getParentElement());
    }

    private void updateLockInfo(@Observes LockInfo lockInfo) {
        if (lockInfo.getFile().equals(this.activity.getPath())) {
            this.lockInfo = lockInfo;
            this.lockSyncComplete = true;
            if (this.activity.isOpen()) {
                this.changeTitleEvent.fire((Object)LockTitleWidgetEvent.create(this.activity, lockInfo));
            }
            this.fireEditorLockEvent();
            for (Runnable runnable : this.syncCompleteRunnables) {
                runnable.run();
            }
            this.syncCompleteRunnables.clear();
        }
    }

    private void onResourceAdded(@Observes ResourceAddedEvent res) {
        if (this.activity != null && res.getPath().equals(this.activity.getPath())) {
            this.releaseLock();
        }
    }

    private void onResourceUpdated(@Observes ResourceUpdatedEvent res) {
        if (this.activity != null && res.getPath().equals(this.activity.getPath())) {
            this.activity.onStartup(this.activity.getPath(), this.activity.getPlace());
            this.releaseLock();
        }
    }

    private native void publishJsApi();

    private boolean isLocked() {
        return this.lockInfo.isLocked();
    }

    private void fireEditorLockEvent() {
        boolean visible;
        com.google.gwt.user.client.Element element = this.activity.getWidget().asWidget().getElement();
        boolean bl = visible = UIObject.isVisible((Element)element) && element.getAbsoluteLeft() > 0 && element.getAbsoluteTop() > 0;
        if (visible) {
            this.editorLockInfoEvent.fire((Object)new EditorLockInfo(this.lockInfo.isLocked(), this.isLockedByCurrentUser()));
        }
    }
}

