/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.access.debug;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.clerezza.rdf.core.access.debug.ReentrantReadWriteLockTracker;

public class ReadLockDebug
extends ReentrantReadWriteLock.ReadLock {
    ReentrantReadWriteLockTracker lock;
    StackTraceElement[] stackTrace;
    ReentrantReadWriteLock.ReadLock readLock;

    public ReadLockDebug(ReentrantReadWriteLockTracker lock) {
        super(lock);
        this.lock = lock;
        this.readLock = lock.realReadLock();
    }

    @Override
    public void lock() {
        this.readLock.lock();
        this.lock.addLockedReadLock(this);
        this.stackTrace = Thread.currentThread().getStackTrace();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.readLock.lockInterruptibly();
    }

    @Override
    public Condition newCondition() {
        return this.readLock.newCondition();
    }

    @Override
    public String toString() {
        return this.readLock.toString();
    }

    @Override
    public boolean tryLock() {
        return this.readLock.tryLock();
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return this.readLock.tryLock(timeout, unit);
    }

    @Override
    public void unlock() {
        this.readLock.unlock();
        this.lock.removeReadLock(this);
        this.stackTrace = null;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }
}

