/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.mvp;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.EventListener;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.UIObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.vfs.impl.LockInfo;
import org.uberfire.backend.vfs.impl.LockResult;
import org.uberfire.client.mvp.LockManager;
import org.uberfire.client.mvp.LockRequiredEvent;
import org.uberfire.client.mvp.LockTarget;
import org.uberfire.client.mvp.LockTitleWidgetEvent;
import org.uberfire.client.mvp.WidgetLockInfo;
import org.uberfire.client.resources.i18n.WorkbenchConstants;
import org.uberfire.client.workbench.VFSLockServiceProxy;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.workbench.events.NotificationEvent;
import org.uberfire.workbench.events.ResourceAddedEvent;
import org.uberfire.workbench.events.ResourceUpdatedEvent;

@Dependent
public class LockManagerImpl
implements LockManager {
    private static final List<String> TAG_CLICK_LOCK_EXCLUSIONS = Arrays.asList("a", "select", "table", "tbody", "tfoot", "td", "tr");
    @Inject
    private VFSLockServiceProxy lockService;
    @Inject
    private Event<ChangeTitleWidgetEvent> changeTitleEvent;
    @Inject
    private Event<WidgetLockInfo> widgetLockInfoEvent;
    @Inject
    private Event<NotificationEvent> lockNotification;
    @Inject
    private User user;
    private LockTarget lockTarget;
    private LockInfo lockInfo = LockInfo.unlocked();
    private HandlerRegistration closeHandler;
    private boolean lockRequestPending;
    private boolean unlockRequestPending;
    private boolean lockSyncComplete;
    private List<Runnable> syncCompleteRunnables = new ArrayList<Runnable>();
    private Timer reloadTimer;

    @Override
    public void init(LockTarget lockTarget) {
        this.lockTarget = lockTarget;
        ParameterizedCommand<LockInfo> command = new ParameterizedCommand<LockInfo>(){

            public void execute(LockInfo lockInfo) {
                if (!LockManagerImpl.this.lockRequestPending && !LockManagerImpl.this.unlockRequestPending) {
                    LockManagerImpl.this.updateLockInfo(lockInfo);
                }
            }
        };
        this.lockService.retrieveLockInfo(lockTarget.getPath(), command);
    }

    @Override
    public void onFocus() {
        this.publishJsApi();
        this.fireChangeTitleEvent();
        this.fireWigetLockInfoEvent();
    }

    @Override
    public void acquireLockOnDemand() {
        if (this.lockTarget == null) {
            return;
        }
        com.google.gwt.user.client.Element element = this.lockTarget.getWidget().getElement();
        com.google.gwt.user.client.Event.sinkEvents((Element)element, (int)1921);
        EventListener lockDemandListener = new EventListener(){

            public void onBrowserEvent(com.google.gwt.user.client.Event event) {
                if (LockManagerImpl.this.isLockRequired(event)) {
                    LockManagerImpl.this.acquireLock();
                }
            }
        };
        com.google.gwt.user.client.Event.setEventListener((Element)element, (EventListener)lockDemandListener);
    }

    private void acquireLock() {
        if (this.lockInfo.isLocked()) {
            this.handleLockFailure(this.lockInfo);
        } else if (!this.lockRequestPending) {
            this.lockRequestPending = true;
            ParameterizedCommand<LockResult> command = new ParameterizedCommand<LockResult>(){

                public void execute(LockResult result) {
                    if (result.isSuccess()) {
                        LockManagerImpl.this.updateLockInfo(result.getLockInfo());
                        LockManagerImpl.this.releaseLockOnClose();
                    } else {
                        LockManagerImpl.this.handleLockFailure(result.getLockInfo());
                    }
                    LockManagerImpl.this.lockRequestPending = false;
                }
            };
            this.lockService.acquireLock(this.lockTarget.getPath(), command);
        }
    }

    @Override
    public void releaseLock() {
        Runnable releaseLock = new Runnable(){

            @Override
            public void run() {
                LockManagerImpl.this.releaseLockInternal();
            }
        };
        if (this.lockSyncComplete) {
            releaseLock.run();
        } else {
            this.syncCompleteRunnables.add(releaseLock);
        }
    }

    private void releaseLockInternal() {
        if (this.isLockedByCurrentUser() && !this.unlockRequestPending) {
            this.unlockRequestPending = true;
            ParameterizedCommand<LockResult> command = new ParameterizedCommand<LockResult>(){

                public void execute(LockResult result) {
                    LockManagerImpl.this.updateLockInfo(result.getLockInfo());
                    if (result.isSuccess() && LockManagerImpl.this.closeHandler != null) {
                        LockManagerImpl.this.closeHandler.removeHandler();
                    }
                    LockManagerImpl.this.unlockRequestPending = false;
                }
            };
            this.lockService.releaseLock(this.lockTarget.getPath(), command);
        }
    }

    private void releaseLockOnClose() {
        this.closeHandler = Window.addCloseHandler((CloseHandler)new CloseHandler<Window>(){

            public void onClose(CloseEvent<Window> event) {
                LockManagerImpl.this.releaseLock();
            }
        });
    }

    private void handleLockFailure(LockInfo lockInfo) {
        if (lockInfo != null) {
            this.updateLockInfo(lockInfo);
            this.lockNotification.fire((Object)new NotificationEvent(WorkbenchConstants.INSTANCE.lockedMessage(lockInfo.lockedBy()), NotificationEvent.NotificationType.INFO, true, this.lockTarget.getPlace(), Integer.valueOf(20)));
        } else {
            this.lockNotification.fire((Object)new NotificationEvent(WorkbenchConstants.INSTANCE.lockError(), NotificationEvent.NotificationType.ERROR, true, this.lockTarget.getPlace(), Integer.valueOf(20)));
        }
        if (this.reloadTimer == null) {
            this.reloadTimer = new Timer(){

                public void run() {
                    LockManagerImpl.this.lockTarget.getReloadRunnable().run();
                }
            };
        }
        if (!this.reloadTimer.isRunning()) {
            this.reloadTimer.schedule(250);
        }
    }

    private boolean isLockedByCurrentUser() {
        return this.lockInfo.isLocked() && this.lockInfo.lockedBy().equals(this.user.getIdentifier());
    }

    private boolean isLockRequired(com.google.gwt.user.client.Event event) {
        if (this.isLockedByCurrentUser()) {
            return false;
        }
        Element target = Element.as((JavaScriptObject)event.getEventTarget());
        String lockAttribute = this.findLockAttribute(target);
        if (lockAttribute != null && !lockAttribute.isEmpty()) {
            return Boolean.parseBoolean(lockAttribute);
        }
        boolean eventExcluded = event.getTypeInt() == 1 && TAG_CLICK_LOCK_EXCLUSIONS.contains(target.getTagName().toLowerCase());
        return !eventExcluded;
    }

    private String findLockAttribute(Element element) {
        if (element == null) {
            return null;
        }
        String lockAttribute = element.getAttribute("data-uf-lock");
        if (lockAttribute != null && !lockAttribute.isEmpty()) {
            return lockAttribute;
        }
        return this.findLockAttribute(element.getParentElement());
    }

    private void updateLockInfo(@Observes LockInfo lockInfo) {
        if (lockInfo.getFile().equals(this.lockTarget.getPath())) {
            this.lockInfo = lockInfo;
            this.lockSyncComplete = true;
            this.fireChangeTitleEvent();
            this.fireWigetLockInfoEvent();
            for (Runnable runnable : this.syncCompleteRunnables) {
                runnable.run();
            }
            this.syncCompleteRunnables.clear();
        }
    }

    private void onResourceAdded(@Observes ResourceAddedEvent res) {
        if (this.lockTarget != null && res.getPath().equals(this.lockTarget.getPath())) {
            this.releaseLock();
        }
    }

    private void onResourceUpdated(@Observes ResourceUpdatedEvent res) {
        if (this.lockTarget != null && res.getPath().equals(this.lockTarget.getPath())) {
            this.lockTarget.getReloadRunnable().run();
            this.releaseLock();
        }
    }

    private void onLockRequired(@Observes LockRequiredEvent event) {
        if (this.isVisible() && !this.isLockedByCurrentUser()) {
            this.acquireLock();
        }
    }

    private native void publishJsApi();

    private boolean isLocked() {
        return this.lockInfo.isLocked();
    }

    private void fireChangeTitleEvent() {
        if (this.isVisible()) {
            this.changeTitleEvent.fire((Object)LockTitleWidgetEvent.create(this.lockTarget, this.lockInfo));
        }
    }

    private void fireWigetLockInfoEvent() {
        if (this.isVisible()) {
            this.widgetLockInfoEvent.fire((Object)new WidgetLockInfo(this.lockInfo.isLocked(), this.isLockedByCurrentUser()));
        }
    }

    private boolean isVisible() {
        com.google.gwt.user.client.Element element = this.lockTarget.getWidget().getElement();
        boolean visible = UIObject.isVisible((Element)element) && element.getAbsoluteLeft() != 0 && element.getAbsoluteTop() != 0;
        return visible;
    }
}

