/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.gwtbootstrap3.client.ui.html.Span;
import org.gwtbootstrap3.client.ui.html.Text;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.container.IOC;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.service.AuthenticationService;
import org.uberfire.client.menu.AuthFilterMenuVisitor;
import org.uberfire.client.views.pfly.menu.DropdownMenuVisitor;
import org.uberfire.client.views.pfly.menu.HasMenuItems;
import org.uberfire.client.workbench.widgets.menu.HasMenus;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBar;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.MenuFactory;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuCustom;

@ApplicationScoped
public class UserMenu
extends AnchorListItem
implements MenuFactory.CustomMenuBuilder,
HasMenus,
HasMenuItems {
    @Inject
    private User user;
    @Inject
    private Caller<AuthenticationService> authService;
    @Inject
    private AuthorizationManager authzManager;
    @Inject
    private WorkbenchMenuBar menubar;
    private final DropDownMenu menu = new DropDownMenu();

    @PostConstruct
    protected void setup() {
        this.anchor.addStyleName("dropdown-toggle");
        this.anchor.setDataToggle(Toggle.DROPDOWN);
        Span userIcon = new Span();
        userIcon.addStyleName("pficon");
        userIcon.addStyleName("pficon-user");
        this.anchor.add((Widget)userIcon);
        this.anchor.add((Widget)new Text(this.formattedUsername()));
        Span caret = new Span();
        caret.addStyleName("caret");
        this.anchor.add((Widget)caret);
        this.addStyleName("dropdown");
        this.add((Widget)this.anchor);
        this.add((Widget)this.menu);
        this.setupLogout();
    }

    protected void setupLogout() {
        AnchorListItem logout = new AnchorListItem("Logout");
        logout.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                UserMenu.this.logout();
            }
        });
        this.menu.add((Widget)logout);
    }

    public void addMenus(Menus menus) {
        menus.accept((MenuVisitor)new AuthFilterMenuVisitor(this.authzManager, this.user, (MenuVisitor)new DropdownMenuVisitor(this)));
    }

    @Override
    public void addMenuItem(MenuPosition position, Widget menuContent) {
        this.menu.insert(menuContent, 0);
    }

    private String formattedUsername() {
        StringBuilder sb = new StringBuilder();
        if (this.user.getProperty("org.jboss.errai.security.FIRST_NAME") != null) {
            sb.append(this.user.getProperty("org.jboss.errai.security.FIRST_NAME"));
        }
        if (this.user.getProperty("org.jboss.errai.security.LAST_NAME") != null) {
            sb.append(" ");
            sb.append(this.user.getProperty("org.jboss.errai.security.LAST_NAME"));
        }
        if (sb.length() == 0) {
            sb.append(this.user.getIdentifier());
        }
        return sb.toString();
    }

    public void logout() {
        ((AuthenticationService)this.authService.call()).logout();
    }

    public void push(MenuFactory.CustomMenuBuilder element) {
    }

    public MenuItem build() {
        return new BaseMenuCustom<IsWidget>(){

            public IsWidget build() {
                return (IsWidget)IOC.getBeanManager().lookupBean(UserMenu.class, new Annotation[0]).getInstance();
            }

            public MenuPosition getPosition() {
                return MenuPosition.RIGHT;
            }
        };
    }
}

