/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.ClientMessageBus;
import org.jboss.errai.bus.client.api.TransportError;
import org.jboss.errai.bus.client.api.TransportErrorHandler;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.Commands;

@EntryPoint
public class WorkbenchBackendEntryPoint {
    @Inject
    private ClientMessageBus bus;
    @Inject
    private ErrorPopupPresenter errorPopupPresenter;
    private boolean askRefresh = false;

    @PostConstruct
    public void init() {
        this.startApp();
    }

    private void startApp() {
        this.bus.addTransportErrorHandler(new TransportErrorHandler(){

            public void onError(TransportError error) {
                if (WorkbenchBackendEntryPoint.this.askRefresh) {
                    return;
                }
                if (error != null && error.getStatusCode() > 400 && error.getStatusCode() < 500) {
                    WorkbenchBackendEntryPoint.this.askRefresh = true;
                    WorkbenchBackendEntryPoint.this.errorPopupPresenter.showMessage("You've been disconnected. Click OK to refresh the application.", Commands.DO_NOTHING, new Command(){

                        public void execute() {
                            WorkbenchBackendEntryPoint.forceReload();
                        }
                    });
                }
            }
        });
    }

    private static native void forceReload();
}

