/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.access.debug;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.clerezza.rdf.core.access.debug.ReentrantReadWriteLockTracker;

public class WriteLockDebug
extends ReentrantReadWriteLock.WriteLock {
    private ReentrantReadWriteLockTracker lock;
    private ReentrantReadWriteLock.WriteLock writeLock;
    private StackTraceElement[] stackTrace;

    public WriteLockDebug(ReentrantReadWriteLockTracker lock) {
        super(lock);
        this.lock = lock;
        this.writeLock = lock.realWriteLock();
    }

    @Override
    public int getHoldCount() {
        return this.writeLock.getHoldCount();
    }

    @Override
    public boolean isHeldByCurrentThread() {
        return this.writeLock.isHeldByCurrentThread();
    }

    @Override
    public void lock() {
        this.writeLock.lock();
        this.stackTrace = Thread.currentThread().getStackTrace();
    }

    @Override
    public void lockInterruptibly() throws InterruptedException {
        this.writeLock.lockInterruptibly();
    }

    @Override
    public Condition newCondition() {
        return this.writeLock.newCondition();
    }

    @Override
    public boolean tryLock() {
        return this.writeLock.tryLock();
    }

    @Override
    public boolean tryLock(long timeout, TimeUnit unit) throws InterruptedException {
        return this.writeLock.tryLock(timeout, unit);
    }

    @Override
    public void unlock() {
        this.writeLock.unlock();
        this.stackTrace = null;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }
}

