/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.menu;

import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.MenuItemPerspective;
import org.uberfire.workbench.model.menu.MenuItemPlain;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;

public class AuthFilterMenuVisitor
implements MenuVisitor {
    private final AuthorizationManager authzManager;
    private final User user;
    private final MenuVisitor chainedVisitor;

    public AuthFilterMenuVisitor(AuthorizationManager authzManager, User user, MenuVisitor chainedVisitor) {
        this.authzManager = (AuthorizationManager)PortablePreconditions.checkNotNull((String)"authzManager", (Object)authzManager);
        this.user = (User)PortablePreconditions.checkNotNull((String)"user", (Object)user);
        this.chainedVisitor = (MenuVisitor)PortablePreconditions.checkNotNull((String)"chainedVisitor", (Object)chainedVisitor);
    }

    public boolean visitEnter(Menus menus) {
        return this.chainedVisitor.visitEnter(menus);
    }

    public void visitLeave(Menus menus) {
        this.chainedVisitor.visitLeave(menus);
    }

    public boolean visitEnter(MenuGroup menuGroup) {
        if (!this.authzManager.authorize((Resource)menuGroup, this.user)) {
            return false;
        }
        return this.chainedVisitor.visitEnter(menuGroup);
    }

    public void visitLeave(MenuGroup menuGroup) {
        this.chainedVisitor.visitLeave(menuGroup);
    }

    public void visit(MenuItemPlain menuItemPlain) {
        if (this.authzManager.authorize((Resource)menuItemPlain, this.user)) {
            this.chainedVisitor.visit(menuItemPlain);
        }
    }

    public void visit(MenuItemCommand menuItemCommand) {
        if (this.authzManager.authorize((Resource)menuItemCommand, this.user)) {
            this.chainedVisitor.visit(menuItemCommand);
        }
    }

    public void visit(MenuCustom<?> menuCustom) {
        if (this.authzManager.authorize(menuCustom, this.user)) {
            this.chainedVisitor.visit(menuCustom);
        }
    }

    public void visit(MenuItemPerspective menuItemPerspective) {
        if (this.authzManager.authorize((Resource)menuItemPerspective, this.user)) {
            this.chainedVisitor.visit(menuItemPerspective);
        }
    }
}

