/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.util.io;

import java.io.IOException;
import java.io.Writer;

public class IndentWriter
extends Writer {
    private Writer base;
    private char[] separatorChars;
    boolean identBeforeNextChar = true;

    public IndentWriter(Writer base) {
        this.base = base;
        String lineSeparator = System.getProperty("line.separator");
        this.separatorChars = lineSeparator.toCharArray();
    }

    public void close() throws IOException {
        this.base.close();
    }

    public void flush() throws IOException {
        this.base.flush();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        int posInSeparatorChars = 0;
        for (int i = 0; i < len; ++i) {
            if (this.identBeforeNextChar) {
                this.base.write(9);
                this.identBeforeNextChar = false;
            }
            this.base.write(cbuf[i]);
            if (cbuf[i] == this.separatorChars[posInSeparatorChars]) {
                if (++posInSeparatorChars != this.separatorChars.length) continue;
                this.identBeforeNextChar = true;
                posInSeparatorChars = 0;
                continue;
            }
            posInSeparatorChars = 0;
        }
    }
}

