/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.bs2.tab;

import com.github.gwtbootstrap.client.ui.DropdownTab;
import com.github.gwtbootstrap.client.ui.Tab;
import com.github.gwtbootstrap.client.ui.TabLink;
import com.github.gwtbootstrap.client.ui.TabPane;
import com.github.gwtbootstrap.client.ui.TabPanel;
import com.github.gwtbootstrap.client.ui.resources.Bootstrap;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.BeforeSelectionEvent;
import com.google.gwt.event.logical.shared.BeforeSelectionHandler;
import com.google.gwt.event.logical.shared.HasBeforeSelectionHandlers;
import com.google.gwt.event.logical.shared.HasSelectionHandlers;
import com.google.gwt.event.logical.shared.SelectionEvent;
import com.google.gwt.event.logical.shared.SelectionHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.ProvidesResize;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.ResizeComposite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.uberfire.client.resources.WorkbenchResources;
import org.uberfire.client.util.Layouts;
import org.uberfire.client.workbench.PanelManager;
import org.uberfire.client.workbench.panels.MultiPartWidget;
import org.uberfire.client.workbench.panels.WorkbenchPanelPresenter;
import org.uberfire.client.workbench.part.WorkbenchPartPresenter;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.PartDefinition;

@Dependent
public class UberTabPanel
extends ResizeComposite
implements MultiPartWidget,
ClickHandler {
    private static final int MARGIN = 20;
    ResizeTabPanel tabPanel;
    private final DropdownTab dropdownTab;
    private boolean updating;
    final List<WorkbenchPartPresenter> parts = new ArrayList<WorkbenchPartPresenter>();
    final Map<WorkbenchPartPresenter.View, TabLink> tabIndex = new HashMap<WorkbenchPartPresenter.View, TabLink>();
    final Map<TabLink, WorkbenchPartPresenter.View> tabInvertedIndex = new HashMap<TabLink, WorkbenchPartPresenter.View>();
    final Map<PartDefinition, TabLink> partTabIndex = new HashMap<PartDefinition, TabLink>();
    private boolean hasFocus = false;
    private final List<Command> focusGainedHandlers = new ArrayList<Command>();
    private final PanelManager panelManager;
    WorkbenchDragAndDropManager dndManager;

    @Inject
    public UberTabPanel(PanelManager panelManager) {
        this(panelManager, new DropdownTab("More..."));
    }

    UberTabPanel(PanelManager panelManager, DropdownTab dropdownTab) {
        this.panelManager = (PanelManager)PortablePreconditions.checkNotNull((String)"panelManager", (Object)panelManager);
        this.dropdownTab = (DropdownTab)PortablePreconditions.checkNotNull((String)"dropdownTab", (Object)dropdownTab);
        this.tabPanel = new ResizeTabPanel(Bootstrap.Tabs.ABOVE);
        this.tabPanel.addShownHandler(new TabPanel.ShownEvent.Handler(){

            public void onShow(TabPanel.ShownEvent e) {
                UberTabPanel.this.onResize();
                if (e.getRelatedTarget() != null) {
                    BeforeSelectionEvent.fire((HasBeforeSelectionHandlers)UberTabPanel.this, (Object)UberTabPanel.this.tabInvertedIndex.get(e.getRelatedTarget()).getPresenter().getDefinition());
                }
            }
        });
        this.tabPanel.addShowHandler(new TabPanel.ShowEvent.Handler(){

            public void onShow(TabPanel.ShowEvent e) {
                if (e.getTarget() == null) {
                    return;
                }
                SelectionEvent.fire((HasSelectionHandlers)UberTabPanel.this, (Object)UberTabPanel.this.tabInvertedIndex.get(e.getTarget()).getPresenter().getDefinition());
            }
        });
        this.tabPanel.addDomHandler((EventHandler)this, ClickEvent.getType());
        this.initWidget((Widget)this.tabPanel);
    }

    public void clear() {
        this.parts.clear();
        this.tabPanel.clear();
        this.dropdownTab.clear();
        this.partTabIndex.clear();
        this.tabIndex.clear();
        this.tabInvertedIndex.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDisplayedTabs() {
        if (this.updating) {
            return;
        }
        try {
            this.updating = true;
            this.tabPanel.clear();
            this.dropdownTab.clear();
            if (this.parts.size() == 0) {
                return;
            }
            int availableSpace = this.tabPanel.getOffsetWidth();
            TabLink selectedTab = null;
            for (int i = 0; i < this.parts.size(); ++i) {
                WorkbenchPartPresenter part = this.parts.get(i);
                TabLink tabWidget = this.partTabIndex.get(part.getDefinition());
                if (tabWidget.isActive()) {
                    selectedTab = tabWidget;
                }
                tabWidget.setActive(false);
                this.tabPanel.add((Widget)tabWidget);
                availableSpace -= tabWidget.getOffsetWidth();
            }
            if (selectedTab == null) {
                TabLink firstTab;
                selectedTab = firstTab = (TabLink)this.getTabs().getWidget(0);
            }
            if (availableSpace < 0) {
                LinkedList<TabLink> newDropdownContents = new LinkedList<TabLink>();
                this.dropdownTab.setText("More...");
                this.tabPanel.add((Widget)this.dropdownTab);
                while (availableSpace - this.dropdownTab.getOffsetWidth() < 0 && this.getTabs().getWidgetCount() > 1) {
                    TabLink tabWidget = (TabLink)this.getTabs().getWidget(this.getTabs().getWidgetCount() - 2);
                    availableSpace += tabWidget.getOffsetWidth();
                    this.tabPanel.remove((Widget)tabWidget);
                    newDropdownContents.addFirst(tabWidget);
                    if (tabWidget != selectedTab) continue;
                    this.dropdownTab.setText(this.tabInvertedIndex.get(selectedTab).getPresenter().getTitle());
                }
                for (TabLink l : newDropdownContents) {
                    this.dropdownTab.add((Widget)l);
                    this.getTabContent().add((Widget)l.getTabPane());
                }
            }
            selectedTab.show();
        }
        finally {
            this.updating = false;
        }
    }

    public boolean selectPart(PartDefinition id) {
        TabLink tab = this.partTabIndex.get(id);
        if (tab != null) {
            tab.show();
        }
        return false;
    }

    public boolean remove(PartDefinition id) {
        TabLink tab = this.partTabIndex.get(id);
        if (tab == null) {
            return false;
        }
        int removedTabIndex = this.getTabs().getWidgetIndex((Widget)tab);
        boolean wasActive = tab.isActive();
        WorkbenchPartPresenter.View partView = this.tabInvertedIndex.remove(tab);
        this.parts.remove(partView.getPresenter());
        this.tabIndex.remove(partView);
        this.partTabIndex.remove(id);
        this.updateDisplayedTabs();
        if (removedTabIndex >= 0 && wasActive && this.getTabs().getWidgetCount() > 0) {
            this.tabPanel.selectTab(removedTabIndex <= 0 ? 0 : removedTabIndex - 1);
        }
        return true;
    }

    public void changeTitle(PartDefinition id, String title, IsWidget titleDecoration) {
        TabLink tabLink = this.partTabIndex.get(id);
        if (tabLink != null) {
            tabLink.setText(title);
        }
    }

    public HandlerRegistration addBeforeSelectionHandler(BeforeSelectionHandler<PartDefinition> handler) {
        return this.addHandler((EventHandler)handler, BeforeSelectionEvent.getType());
    }

    public HandlerRegistration addSelectionHandler(SelectionHandler<PartDefinition> handler) {
        return this.addHandler((EventHandler)handler, SelectionEvent.getType());
    }

    public void setPresenter(WorkbenchPanelPresenter presenter) {
    }

    public void addPart(WorkbenchPartPresenter.View view) {
        if (!this.tabIndex.containsKey(view)) {
            Tab newTab = this.createTab(view, false, 0, 0);
            this.parts.add(view.getPresenter());
            this.tabIndex.put(view, newTab.asTabLink());
            this.updateDisplayedTabs();
        }
    }

    boolean isFirstWidget() {
        return this.getTabs().getWidgetCount() == 1;
    }

    private void resizeIfNeeded(Widget widget) {
        if (this.isAttached() && widget instanceof RequiresResize) {
            ((RequiresResize)widget).onResize();
        }
    }

    Tab createTab(WorkbenchPartPresenter.View view, boolean isActive, int width, int height) {
        Tab tab = this.createTab(view, isActive);
        tab.addClickHandler(this.createTabClickHandler(view, tab));
        tab.add(view.asWidget());
        this.resizeIfNeeded(view.asWidget());
        this.tabIndex.put(view, tab.asTabLink());
        this.tabInvertedIndex.put(tab.asTabLink(), view);
        this.partTabIndex.put(view.getPresenter().getDefinition(), tab.asTabLink());
        this.dndManager.makeDraggable((IsWidget)view, (IsWidget)tab.asTabLink().getWidget(0));
        return this.addCloseToTab(tab);
    }

    Tab createTab(WorkbenchPartPresenter.View view, boolean isActive) {
        Tab tab = new Tab();
        tab.setHeading(view.getPresenter().getTitle());
        tab.setActive(isActive);
        return tab;
    }

    private ClickHandler createTabClickHandler(WorkbenchPartPresenter.View view, Tab tab) {
        return new ClickHandler(){

            public void onClick(ClickEvent event) {
                UberTabPanel.this.onClick(event);
            }
        };
    }

    public void onResize() {
        int width = this.getOffsetWidth();
        int height = this.getOffsetHeight();
        this.updateDisplayedTabs();
        TabLink selectedTab = this.getSelectedTab();
        if (selectedTab != null) {
            TabPane tabPane = selectedTab.getTabPane();
            Widget tabPaneContent = tabPane.getWidget(0);
            tabPaneContent.setPixelSize(width, height - this.getTabHeight());
            this.resizeIfNeeded(tabPaneContent);
        }
    }

    private int getTabHeight() {
        return this.tabPanel.getWidget(0).getOffsetHeight() + 20;
    }

    private ComplexPanel getTabContent() {
        return (ComplexPanel)this.tabPanel.getWidget(1);
    }

    private ComplexPanel getTabs() {
        return (ComplexPanel)this.tabPanel.getWidget(0);
    }

    private Tab addCloseToTab(final Tab tab) {
        Button close = new Button("&times;"){
            {
                super(x0);
                this.setStyleName("close");
                this.addStyleName(WorkbenchResources.INSTANCE.CSS().tabCloseButton());
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        WorkbenchPartPresenter.View partToDeselect = UberTabPanel.this.tabInvertedIndex.get(tab.asTabLink());
                        UberTabPanel.this.panelManager.closePart(partToDeselect.getPresenter().getDefinition());
                    }
                });
            }
        };
        tab.addDecorate((Widget)close);
        return tab;
    }

    public void setDndManager(WorkbenchDragAndDropManager dndManager) {
        this.dndManager = dndManager;
    }

    public void setFocus(boolean hasFocus) {
        this.hasFocus = hasFocus;
        if (hasFocus) {
            this.getTabs().setStyleName(WorkbenchResources.INSTANCE.CSS().activeNavTabs(), true);
        } else {
            this.getTabs().removeStyleName(WorkbenchResources.INSTANCE.CSS().activeNavTabs());
        }
    }

    public void onClick(ClickEvent event) {
        if (!this.hasFocus) {
            this.fireFocusGained();
            WorkbenchPartPresenter.View view = this.getSelectedPart();
            if (view != null) {
                SelectionEvent.fire((HasSelectionHandlers)this, (Object)view.getPresenter().getDefinition());
            }
        }
    }

    private TabLink getSelectedTab() {
        for (TabLink tab : this.tabInvertedIndex.keySet()) {
            if (!tab.isActive()) continue;
            return tab;
        }
        return null;
    }

    private WorkbenchPartPresenter.View getSelectedPart() {
        return this.tabInvertedIndex.get(this.getSelectedTab());
    }

    private void fireFocusGained() {
        for (int i = this.focusGainedHandlers.size() - 1; i >= 0; --i) {
            this.focusGainedHandlers.get(i).execute();
        }
    }

    public void addOnFocusHandler(Command doWhenFocused) {
        this.focusGainedHandlers.add((Command)PortablePreconditions.checkNotNull((String)"doWhenFocused", (Object)doWhenFocused));
    }

    public int getPartsSize() {
        return this.partTabIndex.size();
    }

    static class ResizeTabPanel
    extends TabPanel
    implements RequiresResize,
    ProvidesResize {
        public ResizeTabPanel(Bootstrap.Tabs tabPosition) {
            super(tabPosition);
        }

        public void onResize() {
            for (Widget child : this.getChildren()) {
                Layouts.setToFillParent((Widget)child);
                if (child instanceof RequiresResize) {
                    ((RequiresResize)child).onResize();
                }
                for (Widget grandChild : (HasWidgets)child) {
                    Layouts.setToFillParent((Widget)grandChild);
                }
            }
        }
    }
}

