/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.bs2.menu;

import com.github.gwtbootstrap.client.ui.Dropdown;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.github.gwtbootstrap.client.ui.NavPills;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.workbench.widgets.menu.PartContextMenusPresenter;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.EnabledStateChangeListener;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
public class PartContextMenusView
extends Composite
implements PartContextMenusPresenter.View {
    @Inject
    private AuthorizationManager authzManager;
    @Inject
    private User identity;
    NavPills menuBar = new NavPills();

    public PartContextMenusView() {
        this.initWidget((Widget)this.menuBar);
    }

    public void buildMenu(Menus menus) {
        this.menuBar.clear();
        for (MenuItem menuItem : menus.getItems()) {
            Widget result = this.makeItem(menuItem);
            if (result == null) continue;
            this.menuBar.add(result);
        }
    }

    Widget makeItem(MenuItem item) {
        if (this.notHavePermissionToMakeThis(item)) {
            return null;
        }
        if (item instanceof MenuItemCommand) {
            return this.makeMenuItemCommand(item);
        }
        if (item instanceof MenuGroup) {
            return this.makeMenuGroup((MenuGroup)item);
        }
        return null;
    }

    Widget makeMenuGroup(MenuGroup groups) {
        final ArrayList<Widget> widgetList = new ArrayList<Widget>();
        for (MenuItem _item : groups.getItems()) {
            Widget result = this.makeItem(_item);
            if (result == null) continue;
            widgetList.add(result);
        }
        if (widgetList.isEmpty()) {
            return null;
        }
        return new Dropdown(groups.getCaption()){
            {
                super(x0);
                for (Widget widget : widgetList) {
                    this.add(widget);
                }
            }
        };
    }

    Widget makeMenuItemCommand(final MenuItem item) {
        final MenuItemCommand cmdItem = (MenuItemCommand)item;
        NavLink gwtItem = new NavLink(cmdItem.getCaption()){
            {
                super(x0);
                this.setDisabled(!item.isEnabled());
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        cmdItem.getCommand().execute();
                    }
                });
            }
        };
        item.addEnabledStateChangeListener(new EnabledStateChangeListener((Widget)gwtItem){
            final /* synthetic */ Widget val$gwtItem;
            {
                this.val$gwtItem = widget;
            }

            public void enabledStateChanged(boolean enabled) {
                ((NavLink)this.val$gwtItem).setDisabled(!enabled);
            }
        });
        return gwtItem;
    }

    boolean notHavePermissionToMakeThis(MenuItem item) {
        return !this.authzManager.authorize((Resource)item, this.identity);
    }

    public void clear() {
        this.menuBar.clear();
    }
}

