/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.bs2.menu;

import com.github.gwtbootstrap.client.ui.Dropdown;
import com.github.gwtbootstrap.client.ui.Nav;
import com.github.gwtbootstrap.client.ui.NavLink;
import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.Composite;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import javax.inject.Inject;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBarPresenter;
import org.uberfire.mvp.Command;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.workbench.model.menu.EnabledStateChangeListener;
import org.uberfire.workbench.model.menu.MenuCustom;
import org.uberfire.workbench.model.menu.MenuGroup;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemCommand;
import org.uberfire.workbench.model.menu.MenuPosition;
import org.uberfire.workbench.model.menu.Menus;

public class WorkbenchMenuBarView
extends Composite
implements WorkbenchMenuBarPresenter.View {
    private static WorkbenchMenuBarViewBinder uiBinder = (WorkbenchMenuBarViewBinder)GWT.create(WorkbenchMenuBarViewBinder.class);
    @Inject
    private AuthorizationManager authzManager;
    @Inject
    private User identity;
    @UiField
    public Nav menuBarLeft;
    @UiField
    public Nav menuBarCenter;
    @UiField
    public Nav menuBarRight;

    public WorkbenchMenuBarView() {
        this.initWidget((Widget)uiBinder.createAndBindUi((Object)this));
    }

    public void addMenuItems(Menus menus) {
        for (MenuItem activeMenu : menus.getItems()) {
            Widget result = this.makeItem(activeMenu);
            if (result == null) continue;
            Widget gwtItem = this.makeItem(activeMenu);
            if (activeMenu.getPosition().equals((Object)MenuPosition.LEFT)) {
                this.menuBarLeft.add(gwtItem);
                continue;
            }
            if (activeMenu.getPosition().equals((Object)MenuPosition.CENTER)) {
                this.menuBarCenter.add(gwtItem);
                continue;
            }
            if (!activeMenu.getPosition().equals((Object)MenuPosition.RIGHT)) continue;
            this.menuBarRight.add(gwtItem);
        }
    }

    Widget makeItem(MenuItem item) {
        if (this.notHavePermissionToMakeThis(item)) {
            return null;
        }
        if (item instanceof MenuItemCommand) {
            return this.makeMenuItemCommand(item);
        }
        if (item instanceof MenuGroup) {
            return this.makeMenuGroup((MenuGroup)item);
        }
        if (item instanceof MenuCustom) {
            return this.makeMenuCustom((MenuCustom)item);
        }
        return this.makeNavLink(item);
    }

    Widget makeNavLink(final MenuItem item) {
        final NavLink gwtItem = new NavLink(item.getCaption()){
            {
                super(x0);
                this.setDisabled(!item.isEnabled());
            }
        };
        item.addEnabledStateChangeListener(new EnabledStateChangeListener(){

            public void enabledStateChanged(boolean enabled) {
                gwtItem.setDisabled(!enabled);
            }
        });
        return gwtItem;
    }

    Widget makeMenuCustom(MenuCustom item) {
        MenuCustom custom = item;
        return ((IsWidget)item.build()).asWidget();
    }

    Widget makeMenuGroup(MenuGroup groups) {
        final ArrayList<Widget> widgetList = new ArrayList<Widget>();
        for (MenuItem _item : groups.getItems()) {
            Widget result = this.makeItem(_item);
            if (result == null) continue;
            widgetList.add(result);
        }
        if (widgetList.isEmpty()) {
            return null;
        }
        return new Dropdown(groups.getCaption()){
            {
                super(x0);
                for (Widget widget : widgetList) {
                    this.add(widget);
                }
            }
        };
    }

    Widget makeMenuItemCommand(final MenuItem item) {
        final MenuItemCommand cmdItem = (MenuItemCommand)item;
        NavLink gwtItem = new NavLink(cmdItem.getCaption()){
            {
                super(x0);
                this.setDisabled(!item.isEnabled());
                this.addClickHandler(new ClickHandler(){

                    public void onClick(ClickEvent event) {
                        cmdItem.getCommand().execute();
                    }
                });
            }
        };
        item.addEnabledStateChangeListener(new EnabledStateChangeListener((Widget)gwtItem){
            final /* synthetic */ Widget val$gwtItem;
            {
                this.val$gwtItem = widget;
            }

            public void enabledStateChanged(boolean enabled) {
                ((NavLink)this.val$gwtItem).setDisabled(!enabled);
            }
        });
        return gwtItem;
    }

    boolean notHavePermissionToMakeThis(MenuItem item) {
        return !this.authzManager.authorize((Resource)item, this.identity);
    }

    public void clear() {
        this.menuBarLeft.clear();
        this.menuBarCenter.clear();
        this.menuBarRight.clear();
    }

    public void expand() {
    }

    public void collapse() {
    }

    public void selectMenu(MenuItem menu) {
    }

    public void addCollapseHandler(Command command) {
    }

    public void addExpandHandler(Command command) {
    }

    static interface WorkbenchMenuBarViewBinder
    extends UiBinder<Panel, WorkbenchMenuBarView> {
    }
}

