/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.bs2.modal;

import com.github.gwtbootstrap.client.ui.Close;
import com.github.gwtbootstrap.client.ui.Heading;
import com.github.gwtbootstrap.client.ui.ModalFooter;
import com.github.gwtbootstrap.client.ui.base.DivWidget;
import com.github.gwtbootstrap.client.ui.base.HasVisibility;
import com.github.gwtbootstrap.client.ui.base.HasVisibleHandlers;
import com.github.gwtbootstrap.client.ui.base.IsAnimated;
import com.github.gwtbootstrap.client.ui.constants.BackdropType;
import com.github.gwtbootstrap.client.ui.constants.DismissType;
import com.github.gwtbootstrap.client.ui.event.HiddenEvent;
import com.github.gwtbootstrap.client.ui.event.HiddenHandler;
import com.github.gwtbootstrap.client.ui.event.HideEvent;
import com.github.gwtbootstrap.client.ui.event.HideHandler;
import com.github.gwtbootstrap.client.ui.event.ShowEvent;
import com.github.gwtbootstrap.client.ui.event.ShowHandler;
import com.github.gwtbootstrap.client.ui.event.ShownEvent;
import com.github.gwtbootstrap.client.ui.event.ShownHandler;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.GwtEvent;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.Event;
import com.google.gwt.user.client.ui.RootPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashSet;
import java.util.Set;

public class Modal
extends DivWidget
implements HasVisibility,
HasVisibleHandlers,
IsAnimated {
    private static Set<Modal> currentlyShown = new HashSet<Modal>();
    private final DivWidget header = new DivWidget();
    private final DivWidget body = new DivWidget("modal-body");
    private boolean keyboard = true;
    private BackdropType backdropType = BackdropType.NORMAL;
    private final boolean show = false;
    private boolean hideOthers = true;
    private boolean configured = false;
    private final Close close = new Close(DismissType.MODAL);
    private String title;

    public Modal() {
        super("modal");
        super.add((Widget)this.header);
        super.add((Widget)this.body);
        this.setVisible(false);
    }

    public Modal(boolean animated) {
        this(animated, false);
    }

    public Modal(boolean animated, boolean dynamicSafe) {
        this();
        this.setAnimation(animated);
        this.setDynamicSafe(dynamicSafe);
    }

    public void setDynamicSafe(boolean dynamicSafe) {
        if (dynamicSafe) {
            this.addHiddenHandler(new HiddenHandler(){

                public void onHidden(HiddenEvent hiddenEvent) {
                    Modal.this.unsetHandlerFunctions((Element)Modal.this.getElement());
                    Modal.this.removeFromParent();
                }
            });
        }
    }

    public void setTitle(String title) {
        this.title = title;
        this.header.clear();
        if (title == null || title.isEmpty()) {
            this.showHeader(false);
        } else {
            this.header.add((Widget)this.close);
            this.header.add((Widget)new Heading(3, title));
            this.showHeader(true);
        }
    }

    private void showHeader(boolean show) {
        if (show) {
            this.header.setStyleName("modal-header");
        } else {
            this.header.removeStyleName("modal-header");
        }
    }

    public void setAnimation(boolean animated) {
        if (animated) {
            this.addStyleName("fade");
        } else {
            this.removeStyleName("fade");
        }
    }

    public boolean getAnimation() {
        return this.getStyleName().contains("fade");
    }

    public void setHideOthers(boolean hideOthers) {
        this.hideOthers = hideOthers;
    }

    public void setKeyboard(boolean keyboard) {
        this.keyboard = keyboard;
        this.reconfigure();
    }

    public boolean isKeyboardEnable() {
        return this.keyboard;
    }

    public void setBackdrop(BackdropType type) {
        this.backdropType = type;
        this.reconfigure();
    }

    public BackdropType getBackdropType() {
        return this.backdropType;
    }

    protected void reconfigure() {
        if (this.configured) {
            this.reconfigure(this.keyboard, this.backdropType, false);
        }
    }

    public void add(Widget w) {
        if (w instanceof ModalFooter) {
            super.add(w);
        } else {
            this.body.add(w);
        }
    }

    public void insert(Widget w, int beforeIndex) {
        this.body.insert(w, beforeIndex);
    }

    public void show() {
        if (!this.isAttached()) {
            RootPanel.get().add((Widget)this);
        }
        this.changeVisibility("show");
        this.centerVertically((Element)this.getElement());
    }

    protected void onAttach() {
        super.onAttach();
        this.configure(this.keyboard, this.backdropType, false);
        this.setHandlerFunctions((Element)this.getElement());
        this.configured = true;
    }

    public void hide() {
        this.changeVisibility("hide");
    }

    public void toggle() {
        this.changeVisibility("toggle");
    }

    private void changeVisibility(String visibility) {
        this.changeVisibility((Element)this.getElement(), visibility);
    }

    protected void onHide(Event e) {
        this.fireEvent((GwtEvent)new HideEvent((NativeEvent)e));
    }

    protected void onHidden(Event e) {
        this.fireEvent((GwtEvent)new HiddenEvent((NativeEvent)e));
        currentlyShown.remove((Object)this);
    }

    protected void onShow(Event e) {
        if (this.hideOthers) {
            this.hideShownModals();
        }
        this.fireEvent((GwtEvent)new ShowEvent((NativeEvent)e));
    }

    private void hideShownModals() {
        for (Modal m : currentlyShown) {
            if (((Object)((Object)m)).equals((Object)this)) continue;
            m.hide();
        }
    }

    protected void onShown(Event e) {
        this.fireEvent((GwtEvent)new ShownEvent((NativeEvent)e));
        currentlyShown.add(this);
    }

    private void reconfigure(boolean keyboard, BackdropType backdropType, boolean show) {
        if (backdropType == BackdropType.NORMAL) {
            this.reconfigure((Element)this.getElement(), keyboard, true, show);
        } else if (backdropType == BackdropType.NONE) {
            this.reconfigure((Element)this.getElement(), keyboard, false, show);
        } else if (backdropType == BackdropType.STATIC) {
            this.reconfigure((Element)this.getElement(), keyboard, BackdropType.STATIC.get(), show);
        }
    }

    private void configure(boolean keyboard, BackdropType backdropType, boolean show) {
        if (backdropType == BackdropType.NORMAL) {
            this.configure((Element)this.getElement(), keyboard, true, show);
        } else if (backdropType == BackdropType.NONE) {
            this.configure((Element)this.getElement(), keyboard, false, show);
        } else if (backdropType == BackdropType.STATIC) {
            this.configure((Element)this.getElement(), keyboard, BackdropType.STATIC.get(), show);
        }
    }

    private native void reconfigure(Element var1, boolean var2, boolean var3, boolean var4);

    private native void reconfigure(Element var1, boolean var2, String var3, boolean var4);

    private native void configure(Element var1, boolean var2, boolean var3, boolean var4);

    private native void configure(Element var1, boolean var2, String var3, boolean var4);

    private native void changeVisibility(Element var1, String var2);

    private native void setHandlerFunctions(Element var1);

    private native void unsetHandlerFunctions(Element var1);

    public HandlerRegistration addHideHandler(HideHandler handler) {
        return this.addHandler((EventHandler)handler, HideEvent.getType());
    }

    public HandlerRegistration addHiddenHandler(HiddenHandler handler) {
        return this.addHandler((EventHandler)handler, HiddenEvent.getType());
    }

    public HandlerRegistration addShowHandler(ShowHandler handler) {
        return this.addHandler((EventHandler)handler, ShowEvent.getType());
    }

    public HandlerRegistration addShownHandler(ShownHandler handler) {
        return this.addHandler((EventHandler)handler, ShownEvent.getType());
    }

    public void setCloseVisible(boolean visible) {
        this.close.getElement().getStyle().setVisibility(visible ? Style.Visibility.VISIBLE : Style.Visibility.HIDDEN);
    }

    @Deprecated
    public void setSize(String width, String height) {
        throw new UnsupportedOperationException("modal do not support setSize method");
    }

    public void setWidth(int width) {
        DOM.setStyleAttribute((Element)this.getElement(), (String)"width", (String)(width + "px"));
        DOM.setStyleAttribute((Element)this.getElement(), (String)"marginLeft", (String)(-width / 2 + "px"));
    }

    public void setBodyHeigth(int height) {
        DOM.setStyleAttribute((Element)this.body.getElement(), (String)"height", (String)(height + "px"));
    }

    public void setMaxHeigth(String maxHeight) {
        DOM.setStyleAttribute((Element)this.body.getElement(), (String)"maxHeight", (String)maxHeight);
    }

    private native void centerVertically(Element var1);
}

