/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench.widgets.menu;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.events.PlaceMaximizedEvent;
import org.uberfire.client.workbench.events.PlaceMinimizedEvent;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBar;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.MenuItem;
import org.uberfire.workbench.model.menu.MenuItemPerspective;
import org.uberfire.workbench.model.menu.MenuVisitor;
import org.uberfire.workbench.model.menu.Menus;
import org.uberfire.workbench.model.menu.impl.BaseMenuVisitor;

@ApplicationScoped
public class WorkbenchMenuBarPresenter
implements WorkbenchMenuBar {
    private boolean useExpandedMode = true;
    private boolean expanded = true;
    private final Map<PlaceRequest, MenuItemPerspective> perspectiveMenus = new HashMap<PlaceRequest, MenuItemPerspective>();
    @Inject
    private View view;

    public IsWidget getView() {
        return this.view;
    }

    @PostConstruct
    protected void setup() {
        this.view.addExpandHandler(new Command(){

            public void execute() {
                WorkbenchMenuBarPresenter.this.expanded = true;
            }
        });
        this.view.addCollapseHandler(new Command(){

            public void execute() {
                WorkbenchMenuBarPresenter.this.expanded = false;
            }
        });
    }

    @Override
    public void addMenus(Menus menus) {
        if (menus != null && !menus.getItems().isEmpty()) {
            this.view.addMenuItems(menus);
            menus.accept((MenuVisitor)new BaseMenuVisitor(){

                public void visit(MenuItemPerspective menuItemPerspective) {
                    WorkbenchMenuBarPresenter.this.perspectiveMenus.put(menuItemPerspective.getPlaceRequest(), menuItemPerspective);
                }
            });
        }
    }

    protected void onPerspectiveChange(@Observes PerspectiveChange perspectiveChange) {
        MenuItemPerspective mip = this.perspectiveMenus.get(perspectiveChange.getPlaceRequest());
        if (mip != null) {
            this.view.selectMenu((MenuItem)mip);
        }
    }

    protected void onPlaceMinimized(@Observes PlaceMinimizedEvent event) {
        if (this.isUseExpandedMode()) {
            this.view.expand();
        }
    }

    protected void onPlaceMaximized(@Observes PlaceMaximizedEvent event) {
        this.view.collapse();
    }

    @Override
    public void clear() {
        this.perspectiveMenus.clear();
        this.view.clear();
    }

    @Override
    public void expand() {
        this.useExpandedMode = true;
        this.view.expand();
    }

    @Override
    public boolean isUseExpandedMode() {
        return this.useExpandedMode;
    }

    @Override
    public boolean isExpanded() {
        return this.expanded;
    }

    @Override
    public void collapse() {
        this.useExpandedMode = false;
        this.view.collapse();
    }

    @Override
    public void addCollapseHandler(Command command) {
        this.view.addCollapseHandler(command);
    }

    @Override
    public void addExpandHandler(Command command) {
        this.view.addExpandHandler(command);
    }

    public static interface View
    extends IsWidget {
        public void clear();

        public void addMenuItems(Menus var1);

        public void selectMenu(MenuItem var1);

        public void expand();

        public void collapse();

        public void addCollapseHandler(Command var1);

        public void addExpandHandler(Command var1);
    }
}

