/*
 * Decompiled with CFR 0.152.
 */
package org.wymiwyg.commons.util.text;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class W3CDateFormat
extends DateFormat {
    private static final TimeZone utcTZ = new SimpleTimeZone(0, "UTC");
    private static final long serialVersionUID = 3258407344076372025L;

    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        String string = dateFormat.format(date);
        StringBuffer result = new StringBuffer(string);
        result.insert(string.length() - 2, ':');
        return result;
    }

    public Date parse(String dateString, ParsePosition parsePos) {
        GregorianCalendar resultCalendar;
        int position = parsePos.getIndex();
        int y1 = dateString.charAt(position++) - 48;
        int y2 = dateString.charAt(position++) - 48;
        int y3 = dateString.charAt(position++) - 48;
        int y4 = dateString.charAt(position++) - 48;
        int year = 1000 * y1 + 100 * y2 + 10 * y3 + y4;
        int n = ++position;
        int m1 = dateString.charAt(n) - 48;
        int n2 = ++position;
        ++position;
        int m2 = dateString.charAt(n2) - 48;
        int month = 10 * m1 + m2;
        int n3 = ++position;
        int d1 = dateString.charAt(n3) - 48;
        int n4 = ++position;
        ++position;
        int d2 = dateString.charAt(n4) - 48;
        int day = 10 * d1 + d2;
        if (dateString.length() > ++position) {
            int h1 = dateString.charAt(position++) - 48;
            int h2 = dateString.charAt(position++) - 48;
            int hour = 10 * h1 + h2;
            int n5 = ++position;
            int min1 = dateString.charAt(n5) - 48;
            int n6 = ++position;
            ++position;
            int min2 = dateString.charAt(n6) - 48;
            int minutes = 10 * min1 + min2;
            int n7 = ++position;
            int s1 = dateString.charAt(n7) - 48;
            int n8 = ++position;
            ++position;
            int s2 = dateString.charAt(n8) - 48;
            int secs = 10 * s1 + s2;
            resultCalendar = new GregorianCalendar(year, month - 1, day, hour, minutes, secs);
            ((Calendar)resultCalendar).setTimeZone(utcTZ);
        } else {
            resultCalendar = new GregorianCalendar(year, month - 1, day);
        }
        long timeInMillis = resultCalendar.getTimeInMillis();
        if (dateString.length() > position) {
            if (dateString.charAt(position) == '.') {
                int ms3;
                int ms2;
                char msc2;
                int n9 = ++position;
                int ms1 = dateString.charAt(n9) - 48;
                if ((msc2 = dateString.charAt(++position)) != 'Z' && msc2 != '-' && msc2 != '+') {
                    char msc3;
                    ms2 = msc2 - 48;
                    ms3 = (msc3 = dateString.charAt(++position)) != 'Z' && msc3 != '-' && msc3 != '+' ? msc3 - 48 : 0;
                } else {
                    ms2 = 0;
                    ms3 = 0;
                }
                int msecs = 100 * ms1 + 10 * ms2 + ms3;
                timeInMillis += (long)msecs;
            }
            int n10 = ++position;
            ++position;
            char tzd1 = dateString.charAt(n10);
            if (tzd1 != 'Z') {
                int htz1 = dateString.charAt(position++) - 48;
                int htz2 = dateString.charAt(position++) - 48;
                int hourtz = 10 * htz1 + htz2;
                int n11 = ++position;
                int mintz1 = dateString.charAt(n11) - 48;
                int n12 = ++position;
                ++position;
                int mintz2 = dateString.charAt(n12) - 48;
                int minutestz = 10 * mintz1 + mintz2;
                int offSetInMillis = (hourtz * 60 + minutestz) * 60000;
                timeInMillis = tzd1 == '+' ? (timeInMillis -= (long)offSetInMillis) : (timeInMillis += (long)offSetInMillis);
            }
        }
        parsePos.setIndex(position);
        return new Date(timeInMillis);
    }

    public Date parseOld(String dateString, ParsePosition pos) {
        StringBuffer buffer;
        if (dateString.charAt(dateString.length() - 3) == ':') {
            buffer = new StringBuffer(dateString);
            buffer.deleteCharAt(buffer.length() - 3);
            dateString = buffer.toString();
        }
        if (Character.toUpperCase(dateString.charAt(dateString.length() - 1)) == 'Z') {
            buffer = new StringBuffer(dateString);
            buffer.deleteCharAt(buffer.length() - 1);
            buffer.append("+0000");
            dateString = buffer.toString();
        }
        Date result = null;
        try {
            result = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSZ").parse(dateString, pos);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (result == null) {
            try {
                result = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ").parse(dateString, pos);
            }
            catch (Exception ex1) {
                // empty catch block
            }
        }
        if (result == null) {
            try {
                result = new SimpleDateFormat("yyyy-MM-dd").parse(dateString, pos);
            }
            catch (Exception ex2) {
                System.err.println(" hat a DC:date that could not be parsed, using current");
                return new Date();
            }
        }
        return result;
    }
}

