/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.dropdown;

import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Iterator;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.DropDown;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.ListItem;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.gwtbootstrap3.client.ui.html.Span;

public class ListDropdown
extends DropDown {
    protected Anchor anchor = new Anchor();
    protected DropDownMenu dropDownMenu = new DropDownMenu();
    protected Span caret = new Span();
    protected boolean hideOnSingleElement = true;

    public ListDropdown() {
        super.add((Widget)this.anchor);
        super.add((Widget)this.dropDownMenu);
        this.caret.addStyleName("caret");
        this.addStyleName("uf-list-dropdown");
    }

    public void add(Widget child) {
        if (child instanceof ListItem) {
            this.dropDownMenu.add(child);
            this.addCaretToText();
        }
    }

    public void setText(Widget text) {
        this.removeChildWidgets((ComplexPanel)this.anchor);
        this.anchor.add(text);
        this.addCaretToText();
    }

    public boolean remove(Widget w) {
        boolean remove = this.dropDownMenu.remove(w);
        this.addCaretToText();
        return remove;
    }

    public void setHideOnSingleElement(boolean hide) {
        this.hideOnSingleElement = hide;
    }

    public void clear() {
        this.removeChildWidgets((ComplexPanel)this.anchor);
        this.removeChildWidgets((ComplexPanel)this.dropDownMenu);
    }

    private void removeChildWidgets(ComplexPanel panel) {
        Iterator iterator = panel.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    protected void addCaretToText() {
        if (this.anchor.getWidgetIndex((Widget)this.caret) == -1) {
            if (this.dropDownMenu.getWidgetCount() > 1 || !this.hideOnSingleElement && this.dropDownMenu.getWidgetCount() == 1) {
                this.anchor.add((Widget)this.caret);
                this.anchor.setDataToggle(Toggle.DROPDOWN);
                this.anchor.setDataTargetWidget((Widget)this);
                this.toggleStyles(false);
            }
        } else if (this.hideOnSingleElement && this.dropDownMenu.getWidgetCount() == 1) {
            this.anchor.remove((Widget)this.caret);
            this.anchor.setDataToggle(null);
            this.removeStyleName("open");
            this.toggleStyles(true);
        }
    }

    private void toggleStyles(boolean single) {
        this.removeStyleName("uf-list-dropdown-single");
        this.removeStyleName("uf-list-dropdown-multi");
        this.addStyleName(single ? "uf-list-dropdown-single" : "uf-list-dropdown-multi");
    }
}

