/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixManager;
import org.apache.helix.controller.rebalancer.Rebalancer;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.StateModelDefinition;
import org.apache.log4j.Logger;

public class CustomRebalancer
implements Rebalancer,
MappingCalculator {
    private static final Logger LOG = Logger.getLogger(CustomRebalancer.class);

    @Override
    public void init(HelixManager manager) {
    }

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ClusterDataCache clusterData) {
        return currentIdealState;
    }

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(ClusterDataCache cache, IdealState idealState, Resource resource, CurrentStateOutput currentStateOutput) {
        String stateModelDefName = idealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = cache.getStateModelDef(stateModelDefName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing resource:" + resource.getResourceName()));
        }
        ResourceAssignment partitionMapping = new ResourceAssignment(resource.getResourceName());
        for (Partition partition : resource.getPartitions()) {
            Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resource.getResourceName(), partition);
            Set<String> disabledInstancesForPartition = cache.getDisabledInstancesForPartition(partition.toString());
            Map<String, String> idealStateMap = idealState.getInstanceStateMap(partition.getPartitionName());
            Map<String, String> bestStateForPartition = this.computeCustomizedBestStateForPartition(cache, stateModelDef, idealStateMap, currentStateMap, disabledInstancesForPartition, idealState.isEnabled());
            partitionMapping.addReplicaMap(partition, bestStateForPartition);
        }
        return partitionMapping;
    }

    private Map<String, String> computeCustomizedBestStateForPartition(ClusterDataCache cache, StateModelDefinition stateModelDef, Map<String, String> idealStateMap, Map<String, String> currentStateMap, Set<String> disabledInstancesForPartition, boolean isResourceEnabled) {
        HashMap<String, String> instanceStateMap = new HashMap<String, String>();
        if (currentStateMap != null) {
            for (String instance : currentStateMap.keySet()) {
                if (!(idealStateMap != null && idealStateMap.containsKey(instance) || disabledInstancesForPartition.contains(instance))) {
                    instanceStateMap.put(instance, HelixDefinedState.DROPPED.toString());
                    continue;
                }
                if (currentStateMap.get(instance) != null && currentStateMap.get(instance).equals(HelixDefinedState.ERROR.name()) || isResourceEnabled && !disabledInstancesForPartition.contains(instance)) continue;
                instanceStateMap.put(instance, stateModelDef.getInitialState());
            }
        }
        if (idealStateMap == null) {
            return instanceStateMap;
        }
        Map<String, LiveInstance> liveInstancesMap = cache.getLiveInstances();
        for (String instance : idealStateMap.keySet()) {
            boolean enabled;
            boolean notInErrorState = currentStateMap == null || currentStateMap.get(instance) == null || !currentStateMap.get(instance).equals(HelixDefinedState.ERROR.toString());
            boolean bl = enabled = !disabledInstancesForPartition.contains(instance) && isResourceEnabled;
            if (!liveInstancesMap.containsKey(instance) || !notInErrorState || !enabled) continue;
            instanceStateMap.put(instance, idealStateMap.get(instance));
        }
        return instanceStateMap;
    }
}

