/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.event;

import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.UriRef;

public class FilterTriple {
    private NonLiteral subject;
    private UriRef predicate;
    private Resource object;

    public FilterTriple(NonLiteral subject, UriRef predicate, Resource object) {
        this.subject = subject;
        this.predicate = predicate;
        this.object = object;
    }

    public boolean match(Triple triple) {
        boolean subjectMatch = this.subject == null ? true : this.subject.equals(triple.getSubject());
        boolean predicateMatch = this.predicate == null ? true : this.predicate.equals(triple.getPredicate());
        boolean objectMatch = this.object == null ? true : this.object.equals(triple.getObject());
        return subjectMatch && predicateMatch && objectMatch;
    }

    public String toString() {
        return "FilterTriples: " + this.subject + " " + this.predicate + " " + this.object;
    }
}

