/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.menu;

import com.google.gwt.core.client.GWT;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.user.client.ui.ComplexPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.gwtbootstrap3.client.ui.Anchor;
import org.gwtbootstrap3.client.ui.AnchorButton;
import org.gwtbootstrap3.client.ui.AnchorListItem;
import org.gwtbootstrap3.client.ui.DropDownMenu;
import org.gwtbootstrap3.client.ui.ListDropDown;
import org.gwtbootstrap3.client.ui.constants.Pull;
import org.gwtbootstrap3.client.ui.constants.Toggle;
import org.gwtbootstrap3.client.ui.html.UnorderedList;
import org.uberfire.client.views.pfly.menu.WorkbenchMenuNavBarView;
import org.uberfire.mvp.Command;
import org.uberfire.workbench.model.menu.MenuPosition;

@ApplicationScoped
public class WorkbenchMenuStandardNavBarView
extends WorkbenchMenuNavBarView {
    @Override
    @PostConstruct
    protected void setup() {
        super.setup();
        this.addStyleName("navbar-primary persistent-secondary");
    }

    @Override
    public void addMenuItem(String id, String label, String parentId, final Command command) {
        AnchorListItem menuItem = (AnchorListItem)GWT.create(AnchorListItem.class);
        menuItem.setText(label);
        if (command != null) {
            menuItem.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    command.execute();
                }
            });
        }
        this.getMenuItemWidgetMap().put(id, (ComplexPanel)menuItem);
        if (parentId == null) {
            this.navbarNav.add((Widget)menuItem);
        } else {
            ComplexPanel parent = this.getMenuItemWidgetMap().get(parentId);
            if (parent != null) {
                parent.add((Widget)menuItem);
            }
        }
    }

    @Override
    public void addCustomMenuItem(Widget menu) {
        this.navbarNav.add(menu);
    }

    @Override
    public void addGroupMenuItem(String id, String label) {
        ListDropDown listDropDown = (ListDropDown)GWT.create(ListDropDown.class);
        AnchorButton anchor = (AnchorButton)GWT.create(AnchorButton.class);
        anchor.setDataToggle(Toggle.DROPDOWN);
        anchor.setText(label);
        DropDownMenu dropDownMenu = (DropDownMenu)GWT.create(DropDownMenu.class);
        listDropDown.add((Widget)anchor);
        listDropDown.add((Widget)dropDownMenu);
        this.navbarNav.add((Widget)listDropDown);
        this.getMenuItemWidgetMap().put(id, (ComplexPanel)dropDownMenu);
    }

    @Override
    public void addContextMenuItem(String menuItemId, String id, String label, String parentId, final Command command, MenuPosition position) {
        ComplexPanel contextContainer;
        ComplexPanel menuItemWidget = this.getMenuItemWidgetMap().get(menuItemId);
        if (menuItemWidget == null) {
            return;
        }
        AnchorListItem menuItem = (AnchorListItem)GWT.create(AnchorListItem.class);
        menuItem.setText(label);
        if (command != null) {
            menuItem.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    command.execute();
                }
            });
        }
        if (position == MenuPosition.RIGHT) {
            menuItem.setPull(Pull.RIGHT);
        }
        if ((contextContainer = this.getMenuItemContextWidgetMap().get(parentId)) == null) {
            contextContainer = this.getContextContainer(menuItemId, menuItemWidget);
        }
        contextContainer.add((Widget)menuItem);
        this.getMenuItemContextWidgetMap().put(id, (ComplexPanel)menuItem);
    }

    @Override
    public void addContextGroupMenuItem(String menuItemId, String id, String label) {
        ComplexPanel menuItemWidget = this.getMenuItemWidgetMap().get(menuItemId);
        if (menuItemWidget == null) {
            return;
        }
        ComplexPanel contextContainer = this.getContextContainer(menuItemId, menuItemWidget);
        ListDropDown listDropDown = (ListDropDown)GWT.create(ListDropDown.class);
        listDropDown.setStyleName("dropdown-submenu");
        Anchor anchor = (Anchor)GWT.create(Anchor.class);
        anchor.addStyleName("dropdown-toggle");
        anchor.setDataToggle(Toggle.DROPDOWN);
        anchor.setText(label);
        DropDownMenu dropDownMenu = (DropDownMenu)GWT.create(DropDownMenu.class);
        listDropDown.add((Widget)anchor);
        listDropDown.add((Widget)dropDownMenu);
        contextContainer.add((Widget)listDropDown);
        this.getMenuItemContextWidgetMap().put(id, (ComplexPanel)dropDownMenu);
    }

    private ComplexPanel getContextContainer(String menuItemId, ComplexPanel menuItemWidget) {
        ComplexPanel container = menuItemWidget.getParent().getParent() instanceof ListDropDown ? (ListDropDown)menuItemWidget.getParent().getParent() : menuItemWidget;
        ComplexPanel contextContainer = this.getContextContainerWidgetMap().get(menuItemId);
        if (contextContainer == null) {
            contextContainer = (ComplexPanel)GWT.create(UnorderedList.class);
            contextContainer.addStyleName("nav navbar-nav navbar-persistent");
            contextContainer.addStyleName("uf-perspective-context-menu");
            contextContainer.setVisible(false);
            container.add((Widget)contextContainer);
            this.getContextContainerWidgetMap().put(menuItemId, contextContainer);
        }
        return contextContainer;
    }

    @Override
    public void selectMenuItem(String id) {
        super.selectMenuItem(id);
        for (Map.Entry<String, ComplexPanel> context : this.getContextContainerWidgetMap().entrySet()) {
            if (context.getKey().equals(id)) {
                context.getValue().setVisible(true);
                context.getValue().getParent().addStyleName("uf-perspective-context-menu-container");
                continue;
            }
            context.getValue().setVisible(false);
        }
    }

    @Override
    protected void selectElement(ComplexPanel item) {
        this.iterateWidgets((ComplexPanel)this.navbarNav);
        if (item == null) {
            return;
        }
        item.addStyleName("active");
        if (item.getParent() != null && item.getParent().getParent() instanceof ListDropDown) {
            item.getParent().getParent().addStyleName("active");
        }
    }

    private void iterateWidgets(ComplexPanel widget) {
        widget.removeStyleName("active");
        widget.removeStyleName("uf-perspective-context-menu-container");
        for (Widget next : widget) {
            if (!(next instanceof ComplexPanel)) continue;
            this.iterateWidgets((ComplexPanel)next);
        }
    }
}

