/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.attributes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.AttributesRule;
import org.eclipse.jgit.lib.Constants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributesNode {
    private final List<AttributesRule> rules;

    public AttributesNode() {
        this.rules = new ArrayList<AttributesRule>();
    }

    public AttributesNode(List<AttributesRule> rules) {
        this.rules = rules;
    }

    public void parse(InputStream in) throws IOException {
        String txt;
        BufferedReader br = AttributesNode.asReader(in);
        while ((txt = br.readLine()) != null) {
            if ((txt = txt.trim()).length() <= 0 || txt.startsWith("#") || txt.startsWith("!")) continue;
            int patternEndSpace = txt.indexOf(32);
            int patternEndTab = txt.indexOf(9);
            int patternEnd = patternEndSpace == -1 ? patternEndTab : (patternEndTab == -1 ? patternEndSpace : Math.min(patternEndSpace, patternEndTab));
            if (patternEnd <= -1) continue;
            this.rules.add(new AttributesRule(txt.substring(0, patternEnd), txt.substring(patternEnd + 1).trim()));
        }
    }

    private static BufferedReader asReader(InputStream in) {
        return new BufferedReader(new InputStreamReader(in, Constants.CHARSET));
    }

    public List<AttributesRule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public void getAttributes(String entryPath, boolean isDirectory, Map<String, Attribute> attributes) {
        ListIterator<AttributesRule> ruleIterator = this.rules.listIterator(this.rules.size());
        while (ruleIterator.hasPrevious()) {
            AttributesRule rule = ruleIterator.previous();
            if (!rule.isMatch(entryPath, isDirectory)) continue;
            ListIterator<Attribute> attributeIte = rule.getAttributes().listIterator(rule.getAttributes().size());
            while (attributeIte.hasPrevious()) {
                Attribute attr = attributeIte.previous();
                if (attributes.containsKey(attr.getKey())) continue;
                attributes.put(attr.getKey(), attr);
            }
        }
    }
}

