/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import java.util.Iterator;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.Role;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.GroupsResource;
import org.uberfire.security.authz.ProfileDecisionManager;
import org.uberfire.security.authz.ProfilesResource;
import org.uberfire.security.authz.RolesResource;

public class DefaultProfileDecisionManager
implements ProfileDecisionManager {
    @Override
    public Iterable<AuthorizationResult> decide(final ProfilesResource resource, final User user) {
        PortablePreconditions.checkNotNull((String)"resource", (Object)resource);
        PortablePreconditions.checkNotNull((String)"subject", (Object)user);
        if (resource instanceof RolesResource) {
            return new Iterable<AuthorizationResult>(){

                @Override
                public Iterator<AuthorizationResult> iterator() {
                    return new Iterator<AuthorizationResult>(){
                        private final Iterator<Role> iterator;
                        {
                            this.iterator = ((RolesResource)resource).getRoles().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.iterator.hasNext();
                        }

                        @Override
                        public AuthorizationResult next() {
                            Role role = this.iterator.next();
                            if (user.getRoles().contains(role)) {
                                return AuthorizationResult.ACCESS_GRANTED;
                            }
                            return AuthorizationResult.ACCESS_ABSTAIN;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("Remove not supported.");
                        }
                    };
                }
            };
        }
        return new Iterable<AuthorizationResult>(){

            @Override
            public Iterator<AuthorizationResult> iterator() {
                return new Iterator<AuthorizationResult>(){
                    private final Iterator<Group> iterator;
                    {
                        this.iterator = ((GroupsResource)resource).getGroups().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iterator.hasNext();
                    }

                    @Override
                    public AuthorizationResult next() {
                        Group group = this.iterator.next();
                        if (user.getGroups().contains(group)) {
                            return AuthorizationResult.ACCESS_GRANTED;
                        }
                        return AuthorizationResult.ACCESS_ABSTAIN;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove not supported.");
                    }
                };
            }
        };
    }
}

