/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.core;

import java.io.IOException;
import org.uberfire.relocated.freemarker.core.Environment;
import org.uberfire.relocated.freemarker.core.Expression;
import org.uberfire.relocated.freemarker.core.TemplateElement;
import org.uberfire.relocated.freemarker.template.TemplateException;

class EscapeBlock
extends TemplateElement {
    private final String variable;
    private final Expression expr;
    private Expression escapedExpr;

    EscapeBlock(String variable, Expression expr, Expression escapedExpr) {
        this.variable = variable;
        this.expr = expr;
        this.escapedExpr = escapedExpr;
    }

    void setContent(TemplateElement nestedBlock) {
        this.nestedBlock = nestedBlock;
        this.escapedExpr = null;
    }

    void accept(Environment env) throws TemplateException, IOException {
        if (this.nestedBlock != null) {
            env.visit(this.nestedBlock);
        }
    }

    Expression doEscape(Expression subst) {
        return this.escapedExpr.deepClone(this.variable, subst);
    }

    public String getDescription() {
        return "escape " + this.variable + " as " + this.expr.toString();
    }

    public String getCanonicalForm() {
        return "<#escape " + this.variable + " as " + this.expr.getCanonicalForm() + ">" + this.nestedBlock.getCanonicalForm() + "</#escape>";
    }
}

