/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.core;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.uberfire.relocated.freemarker.core.Environment;
import org.uberfire.relocated.freemarker.core.Expression;
import org.uberfire.relocated.freemarker.core.ListLiteral;
import org.uberfire.relocated.freemarker.core.Macro;
import org.uberfire.relocated.freemarker.template.TemplateException;
import org.uberfire.relocated.freemarker.template.TemplateMethodModel;
import org.uberfire.relocated.freemarker.template.TemplateMethodModelEx;
import org.uberfire.relocated.freemarker.template.TemplateModel;

final class MethodCall
extends Expression {
    private final Expression target;
    private final ListLiteral arguments;

    MethodCall(Expression target, ArrayList arguments) {
        this(target, new ListLiteral(arguments));
    }

    private MethodCall(Expression target, ListLiteral arguments) {
        this.target = target;
        this.arguments = arguments;
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        TemplateModel targetModel = this.target.getAsTemplateModel(env);
        if (targetModel instanceof TemplateMethodModel) {
            TemplateMethodModel targetMethod = (TemplateMethodModel)targetModel;
            List argumentStrings = targetMethod instanceof TemplateMethodModelEx ? this.arguments.getModelList(env) : this.arguments.getValueList(env);
            Object result = targetMethod.exec(argumentStrings);
            return env.getObjectWrapper().wrap(result);
        }
        if (targetModel instanceof Macro) {
            Macro func = (Macro)targetModel;
            env.setLastReturnValue(null);
            if (!func.isFunction) {
                throw new TemplateException("A macro cannot be called in an expression.", env);
            }
            Writer prevOut = env.getOut();
            try {
                env.setOut(Environment.NULL_WRITER);
                env.visit(func, null, this.arguments.values, null, null);
            }
            catch (IOException ioe) {
                throw new InternalError("This should be impossible.");
            }
            finally {
                env.setOut(prevOut);
            }
            return env.getLastReturnValue();
        }
        throw MethodCall.invalidTypeException(targetModel, this.target, env, "method");
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.target.getCanonicalForm());
        buf.append("(");
        String list = this.arguments.getCanonicalForm();
        buf.append(list.substring(1, list.length() - 1));
        buf.append(")");
        return buf.toString();
    }

    TemplateModel getConstantValue() {
        return null;
    }

    boolean isLiteral() {
        return false;
    }

    Expression _deepClone(String name, Expression subst) {
        return new MethodCall(this.target.deepClone(name, subst), (ListLiteral)this.arguments.deepClone(name, subst));
    }
}

