/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.splash;

import com.google.gwt.event.logical.shared.CloseEvent;
import com.google.gwt.event.logical.shared.CloseHandler;
import com.google.gwt.user.client.ui.HTML;
import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collection;
import org.uberfire.client.mvp.SplashScreenActivity;
import org.uberfire.client.splash.JSNativeSplashScreen;
import org.uberfire.client.workbench.widgets.splash.SplashView;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.SplashScreenFilter;

public class JSSplashScreenActivity
implements SplashScreenActivity {
    private Boolean showAgain = Boolean.TRUE;
    private Boolean isEnabled = Boolean.TRUE;
    private SplashScreenFilter splashFilter;
    private final JSNativeSplashScreen nativeSplashScreen;
    private PlaceRequest place;
    private final SplashView splash;

    public JSSplashScreenActivity(JSNativeSplashScreen nativeSplashScreen, SplashView splashView) {
        this.nativeSplashScreen = (JSNativeSplashScreen)PortablePreconditions.checkNotNull((String)"nativeSplashScreen", (Object)nativeSplashScreen);
        this.splash = (SplashView)PortablePreconditions.checkNotNull((String)"splashView", (Object)splashView);
        this.isEnabled = nativeSplashScreen.isEnabled();
        this.splashFilter = nativeSplashScreen.buildFilter();
    }

    public void onStartup(PlaceRequest place) {
        this.place = place;
        this.nativeSplashScreen.getWbServices().loadSplashScreenFilter(this.getFilter().getName(), (ParameterizedCommand)new ParameterizedCommand<SplashScreenFilter>(){

            public void execute(SplashScreenFilter response) {
                if (response != null) {
                    JSSplashScreenActivity.this.splashFilter = response;
                }
                JSSplashScreenActivity.this.init();
            }
        });
        this.nativeSplashScreen.onStartup(place);
    }

    public PlaceRequest getPlace() {
        return this.place;
    }

    public String getIdentifier() {
        return this.nativeSplashScreen.getId();
    }

    public void init() {
        if (!this.splashFilter.displayNextTime()) {
            return;
        }
        this.forceShow();
    }

    public String getTitle() {
        return this.nativeSplashScreen.getTitle();
    }

    public IsWidget getWidget() {
        return new HTML(this.nativeSplashScreen.getElement().getInnerHTML());
    }

    public Integer getBodyHeight() {
        return this.nativeSplashScreen.getBodyHeight();
    }

    public SplashScreenFilter getFilter() {
        return this.splashFilter;
    }

    public IsWidget getTitleDecoration() {
        return null;
    }

    public void onOpen() {
        this.nativeSplashScreen.onOpen();
    }

    public void closeIfOpen() {
        if (this.splash.isAttached()) {
            this.splash.hide();
            this.onClose();
        }
    }

    public void forceShow() {
        IsWidget widget = this.getWidget();
        this.splash.setContent(widget, this.getBodyHeight());
        this.splash.setTitle(this.getTitle());
        this.splash.show();
        this.splash.addCloseHandler((CloseHandler)new CloseHandler<SplashView>(){

            public void onClose(CloseEvent<SplashView> event) {
                JSSplashScreenActivity.this.onClose();
            }
        });
    }

    public void onClose() {
        this.nativeSplashScreen.onClose();
        this.saveState();
    }

    public void onShutdown() {
        this.nativeSplashScreen.onShutdown();
    }

    public Boolean intercept(PlaceRequest intercepted) {
        if (this.splashFilter == null) {
            return false;
        }
        for (String interceptPoint : this.splashFilter.getInterceptionPoints()) {
            if (!intercepted.getIdentifier().equals(interceptPoint)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    private void saveState() {
        this.showAgain = this.splash.showAgain();
        if (this.showAgain != null) {
            this.splashFilter.setDisplayNextTime(this.showAgain.booleanValue());
            this.nativeSplashScreen.getWbServices().save(this.splashFilter);
        }
    }

    public String getSignatureId() {
        return this.nativeSplashScreen.getId();
    }

    public Collection<String> getRoles() {
        return this.nativeSplashScreen.getRoles();
    }

    public Collection<String> getTraits() {
        return this.nativeSplashScreen.getTraits();
    }
}

