/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.dnd;

import com.allen_sauer.gwt.dnd.client.DragContext;
import com.allen_sauer.gwt.dnd.client.VetoDragException;
import com.allen_sauer.gwt.dnd.client.util.CoordinateArea;
import com.allen_sauer.gwt.dnd.client.util.CoordinateLocation;
import com.allen_sauer.gwt.dnd.client.util.Location;
import com.allen_sauer.gwt.dnd.client.util.WidgetArea;
import com.google.gwt.core.client.GWT;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.uibinder.client.UiBinder;
import com.google.gwt.uibinder.client.UiField;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.PopupPanel;
import com.google.gwt.user.client.ui.Widget;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import org.uberfire.client.resources.WorkbenchResources;
import org.uberfire.client.workbench.widgets.dnd.CompassWidget;
import org.uberfire.workbench.model.CompassPosition;
import org.uberfire.workbench.model.Position;

@ApplicationScoped
public class CompassWidgetImpl
implements CompassWidget {
    public static final String FA_ACTIVE = "fa-active";
    private static CompassWidgetBinder uiBinder = (CompassWidgetBinder)GWT.create(CompassWidgetBinder.class);
    private Element dropTargetHighlight;
    @UiField
    DockLayoutPanel container;
    @UiField
    PopupPanel popup;
    @UiField
    Widget south;
    @UiField
    Widget north;
    @UiField
    Widget west;
    @UiField
    Widget east;
    @UiField
    Widget centre;
    private CompassPosition dropTargetPosition = CompassPosition.NONE;

    @PostConstruct
    void init() {
        this.popup = (PopupPanel)uiBinder.createAndBindUi(this);
        if (this.dropTargetHighlight == null) {
            this.dropTargetHighlight = Document.get().createDivElement();
            this.dropTargetHighlight.getStyle().setPosition(Style.Position.ABSOLUTE);
            this.dropTargetHighlight.getStyle().setVisibility(Style.Visibility.HIDDEN);
            this.dropTargetHighlight.setClassName(WorkbenchResources.INSTANCE.CSS().dropTargetHighlight());
            Document.get().getBody().appendChild((Node)this.dropTargetHighlight);
        }
        this.north.ensureDebugId("CompassWidget-north");
        this.south.ensureDebugId("CompassWidget-south");
        this.east.ensureDebugId("CompassWidget-east");
        this.west.ensureDebugId("CompassWidget-west");
        this.centre.ensureDebugId("CompassWidget-centre");
    }

    public void onEnter(DragContext context) {
        this.show(context);
    }

    public void onLeave(DragContext context) {
        this.popup.hide();
    }

    public void onMove(DragContext context) {
        CoordinateLocation l = new CoordinateLocation(context.mouseX, context.mouseY);
        WidgetArea northWidgetArea = new WidgetArea(this.north, null);
        WidgetArea southWidgetArea = new WidgetArea(this.south, null);
        WidgetArea eastWidgetArea = new WidgetArea(this.east, null);
        WidgetArea westWidgetArea = new WidgetArea(this.west, null);
        WidgetArea centreWidgetArea = new WidgetArea(this.centre, null);
        CompassPosition p = CompassPosition.NONE;
        if (northWidgetArea.intersects((Location)l)) {
            p = CompassPosition.NORTH;
        } else if (southWidgetArea.intersects((Location)l)) {
            p = CompassPosition.SOUTH;
        } else if (eastWidgetArea.intersects((Location)l)) {
            p = CompassPosition.EAST;
        } else if (westWidgetArea.intersects((Location)l)) {
            p = CompassPosition.WEST;
        } else if (centreWidgetArea.intersects((Location)l)) {
            p = CompassPosition.SELF;
        }
        if (p != this.dropTargetPosition) {
            this.dropTargetPosition = p;
            this.showDropTarget(context, p);
        }
    }

    public Position getDropPosition() {
        return this.dropTargetPosition;
    }

    public Widget getDropTarget() {
        throw new UnsupportedOperationException();
    }

    public void onDrop(DragContext context) {
        this.dropTargetPosition = CompassPosition.NONE;
        this.highlightActiveDropTarget(null);
        this.hideDropTarget();
    }

    public void onPreviewDrop(DragContext context) throws VetoDragException {
        throw new UnsupportedOperationException();
    }

    private void show(DragContext context) {
        Widget dropTargetParent = context.dropController.getDropTarget();
        int cxmin = dropTargetParent.getElement().getAbsoluteLeft();
        int cymin = dropTargetParent.getElement().getAbsoluteTop();
        int cxmax = dropTargetParent.getElement().getAbsoluteRight();
        int cymax = dropTargetParent.getElement().getAbsoluteBottom();
        final CoordinateArea ca = new CoordinateArea(cxmin, cymin, cxmax, cymax);
        if (!this.popup.isAttached()) {
            this.popup.setPopupPositionAndShow(new PopupPanel.PositionCallback(){

                public void setPosition(int offsetWidth, int offsetHeight) {
                    CompassWidgetImpl.this.popup.setPopupPosition(ca.getCenter().getLeft() - offsetWidth / 2, ca.getCenter().getTop() - offsetHeight / 2);
                }
            });
        } else {
            this.popup.setPopupPosition(ca.getCenter().getLeft() - this.popup.getOffsetWidth() / 2, ca.getCenter().getTop() - this.popup.getOffsetHeight() / 2);
        }
    }

    private void showDropTarget(DragContext context, CompassPosition p) {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        Widget dropTargetParent = context.dropController.getDropTarget();
        switch (p) {
            case SELF: {
                x = dropTargetParent.getAbsoluteLeft();
                y = dropTargetParent.getAbsoluteTop();
                width = dropTargetParent.getOffsetWidth();
                height = dropTargetParent.getOffsetHeight();
                this.highlightActiveDropTarget(this.centre);
                this.showDropTarget(x, y, width, height);
                break;
            }
            case NORTH: {
                x = dropTargetParent.getAbsoluteLeft();
                y = dropTargetParent.getAbsoluteTop();
                width = dropTargetParent.getOffsetWidth();
                height = (int)((double)dropTargetParent.getOffsetHeight() * 0.5);
                this.highlightActiveDropTarget(this.north);
                this.showDropTarget(x, y, width, height);
                break;
            }
            case SOUTH: {
                x = dropTargetParent.getAbsoluteLeft();
                height = (int)((double)dropTargetParent.getOffsetHeight() * 0.5);
                y = dropTargetParent.getOffsetHeight() + dropTargetParent.getAbsoluteTop() - height;
                width = dropTargetParent.getOffsetWidth();
                this.highlightActiveDropTarget(this.south);
                this.showDropTarget(x, y, width, height);
                break;
            }
            case EAST: {
                width = (int)((double)dropTargetParent.getOffsetWidth() * 0.5);
                x = dropTargetParent.getOffsetWidth() + dropTargetParent.getAbsoluteLeft() - width;
                y = dropTargetParent.getAbsoluteTop();
                height = dropTargetParent.getOffsetHeight();
                this.highlightActiveDropTarget(this.east);
                this.showDropTarget(x, y, width, height);
                break;
            }
            case WEST: {
                x = dropTargetParent.getAbsoluteLeft();
                y = dropTargetParent.getAbsoluteTop();
                width = (int)((double)dropTargetParent.getOffsetWidth() * 0.5);
                height = dropTargetParent.getOffsetHeight();
                this.highlightActiveDropTarget(this.west);
                this.showDropTarget(x, y, width, height);
                break;
            }
            default: {
                this.highlightActiveDropTarget(null);
                this.hideDropTarget();
            }
        }
    }

    private void highlightActiveDropTarget(Widget target) {
        this.south.removeStyleName(FA_ACTIVE);
        this.north.removeStyleName(FA_ACTIVE);
        this.west.removeStyleName(FA_ACTIVE);
        this.east.removeStyleName(FA_ACTIVE);
        this.centre.removeStyleName(FA_ACTIVE);
        if (target != null) {
            target.addStyleName(FA_ACTIVE);
        }
    }

    private void showDropTarget(int x, int y, int width, int height) {
        this.dropTargetHighlight.getStyle().setLeft((double)x, Style.Unit.PX);
        this.dropTargetHighlight.getStyle().setWidth((double)width, Style.Unit.PX);
        this.dropTargetHighlight.getStyle().setTop((double)y, Style.Unit.PX);
        this.dropTargetHighlight.getStyle().setHeight((double)height, Style.Unit.PX);
        this.dropTargetHighlight.getStyle().setVisibility(Style.Visibility.VISIBLE);
        this.dropTargetHighlight.getStyle().setDisplay(Style.Display.BLOCK);
    }

    private void hideDropTarget() {
        this.dropTargetHighlight.getStyle().setVisibility(Style.Visibility.HIDDEN);
        this.dropTargetHighlight.getStyle().setDisplay(Style.Display.NONE);
        this.dropTargetPosition = CompassPosition.NONE;
    }

    static interface CompassWidgetBinder
    extends UiBinder<PopupPanel, CompassWidgetImpl> {
    }
}

