/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import javax.ws.rs.ext.Providers;
import org.jboss.resteasy.core.ValueInjector;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.LoggableFailure;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class ContextParameterInjector
implements ValueInjector {
    private Class type;
    private ResteasyProviderFactory factory;

    public ContextParameterInjector(Class type, ResteasyProviderFactory factory) {
        this.type = type;
        this.factory = factory;
    }

    @Override
    public Object inject(HttpRequest request, HttpResponse response) {
        if (this.type.equals(Providers.class)) {
            return this.factory;
        }
        if (!this.type.isInterface()) {
            return ResteasyProviderFactory.getContextData(this.type);
        }
        Class[] intfs = new Class[]{this.type};
        return Proxy.newProxyInstance(this.type.getClassLoader(), intfs, (InvocationHandler)new GenericDelegatingProxy());
    }

    @Override
    public Object inject() {
        if (this.type.equals(Providers.class)) {
            return this.factory;
        }
        if (!this.type.isInterface()) {
            Object delegate = ResteasyProviderFactory.getContextData(this.type);
            if (delegate != null) {
                return delegate;
            }
            throw new RuntimeException(Messages.MESSAGES.illegalToInjectNonInterfaceType());
        }
        Class[] intfs = new Class[]{this.type};
        return Proxy.newProxyInstance(this.type.getClassLoader(), intfs, (InvocationHandler)new GenericDelegatingProxy());
    }

    private class GenericDelegatingProxy
    implements InvocationHandler {
        private GenericDelegatingProxy() {
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            try {
                Object delegate = ResteasyProviderFactory.getContextData(ContextParameterInjector.this.type);
                if (delegate == null) {
                    throw new LoggableFailure(Messages.MESSAGES.unableToFindContextualData(ContextParameterInjector.this.type.getName()));
                }
                return method.invoke(delegate, objects);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new ApplicationException(e.getCause());
            }
        }
    }
}

