/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.stages;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.helix.model.Partition;

public class BestPossibleStateOutput {
    Map<String, Map<Partition, Map<String, String>>> _stateMap = new HashMap<String, Map<Partition, Map<String, String>>>();

    public Set<String> resourceSet() {
        return this._stateMap.keySet();
    }

    public void setState(String resourceName, Partition resource, Map<String, String> bestInstanceStateMappingForResource) {
        if (!this._stateMap.containsKey(resourceName)) {
            this._stateMap.put(resourceName, new HashMap());
        }
        Map<Partition, Map<String, String>> map = this._stateMap.get(resourceName);
        map.put(resource, bestInstanceStateMappingForResource);
    }

    public void setState(String resourceName, Partition partition, String instance, String state) {
        if (!this._stateMap.containsKey(resourceName)) {
            this._stateMap.put(resourceName, new HashMap());
        }
        if (!this._stateMap.get(resourceName).containsKey(partition)) {
            this._stateMap.get(resourceName).put(partition, new HashMap());
        }
        this._stateMap.get(resourceName).get(partition).put(instance, state);
    }

    public Map<String, String> getInstanceStateMap(String resourceName, Partition partition) {
        Map<Partition, Map<String, String>> map = this._stateMap.get(resourceName);
        if (map != null) {
            return map.get(partition);
        }
        return Collections.emptyMap();
    }

    public Map<Partition, Map<String, String>> getResourceMap(String resourceName) {
        Map<Partition, Map<String, String>> map = this._stateMap.get(resourceName);
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    public Map<String, Map<Partition, Map<String, String>>> getStateMap() {
        return this._stateMap;
    }

    public String toString() {
        return this._stateMap.toString();
    }
}

