/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.spectator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.helix.ConfigChangeListener;
import org.apache.helix.ExternalViewChangeListener;
import org.apache.helix.HelixDataAccessor;
import org.apache.helix.NotificationContext;
import org.apache.helix.PropertyKey;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.InstanceConfig;
import org.apache.log4j.Logger;

public class RoutingTableProvider
implements ExternalViewChangeListener,
ConfigChangeListener {
    private static final Logger logger = Logger.getLogger(RoutingTableProvider.class);
    private final AtomicReference<RoutingTable> _routingTableRef = new AtomicReference<RoutingTable>(new RoutingTable());

    public List<InstanceConfig> getInstances(String resourceName, String partitionName, String state) {
        PartitionInfo keyInfo;
        List<InstanceConfig> instanceList = null;
        RoutingTable _routingTable = this._routingTableRef.get();
        ResourceInfo resourceInfo = _routingTable.get(resourceName);
        if (resourceInfo != null && (keyInfo = resourceInfo.get(partitionName)) != null) {
            instanceList = keyInfo.get(state);
        }
        if (instanceList == null) {
            instanceList = Collections.emptyList();
        }
        return instanceList;
    }

    public Set<InstanceConfig> getInstances(String resource, String state) {
        Set<InstanceConfig> instanceSet = null;
        RoutingTable routingTable = this._routingTableRef.get();
        ResourceInfo resourceInfo = routingTable.get(resource);
        if (resourceInfo != null) {
            instanceSet = resourceInfo.getInstances(state);
        }
        if (instanceSet == null) {
            instanceSet = Collections.emptySet();
        }
        return instanceSet;
    }

    @Override
    public void onExternalViewChange(List<ExternalView> externalViewList, NotificationContext changeContext) {
        if (changeContext.getType() == NotificationContext.Type.FINALIZE) {
            logger.info((Object)"Resetting the routing table. ");
            RoutingTable newRoutingTable = new RoutingTable();
            this._routingTableRef.set(newRoutingTable);
            return;
        }
        this.refresh(externalViewList, changeContext);
    }

    @Override
    public void onConfigChange(List<InstanceConfig> configs, NotificationContext changeContext) {
        if (changeContext.getType() == NotificationContext.Type.FINALIZE) {
            logger.info((Object)"Resetting the routing table. ");
            RoutingTable newRoutingTable = new RoutingTable();
            this._routingTableRef.set(newRoutingTable);
            return;
        }
        HelixDataAccessor accessor = changeContext.getManager().getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        List<ExternalView> externalViewList = accessor.getChildValues(keyBuilder.externalViews());
        this.refresh(externalViewList, changeContext);
    }

    private void refresh(List<ExternalView> externalViewList, NotificationContext changeContext) {
        HelixDataAccessor accessor = changeContext.getManager().getHelixDataAccessor();
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        List configList = accessor.getChildValues(keyBuilder.instanceConfigs());
        HashMap<String, InstanceConfig> instanceConfigMap = new HashMap<String, InstanceConfig>();
        for (InstanceConfig config : configList) {
            instanceConfigMap.put(config.getId(), config);
        }
        RoutingTable newRoutingTable = new RoutingTable();
        if (externalViewList != null) {
            for (ExternalView extView : externalViewList) {
                String resourceName = extView.getId();
                for (String partitionName : extView.getPartitionSet()) {
                    Map<String, String> stateMap = extView.getStateMap(partitionName);
                    for (String instanceName : stateMap.keySet()) {
                        String currentState = stateMap.get(instanceName);
                        if (instanceConfigMap.containsKey(instanceName)) {
                            InstanceConfig instanceConfig = (InstanceConfig)instanceConfigMap.get(instanceName);
                            newRoutingTable.addEntry(resourceName, partitionName, currentState, instanceConfig);
                            continue;
                        }
                        logger.error((Object)("Invalid instance name." + instanceName + " .Not found in /cluster/configs/. instanceName: "));
                    }
                }
            }
        }
        this._routingTableRef.set(newRoutingTable);
    }

    class PartitionInfo {
        HashMap<String, List<InstanceConfig>> stateInfoMap = new HashMap();

        public void addEntry(String state, InstanceConfig config) {
            if (!this.stateInfoMap.containsKey(state)) {
                this.stateInfoMap.put(state, new ArrayList());
            }
            List<InstanceConfig> list = this.stateInfoMap.get(state);
            list.add(config);
        }

        List<InstanceConfig> get(String state) {
            return this.stateInfoMap.get(state);
        }
    }

    class ResourceInfo {
        HashMap<String, PartitionInfo> partitionInfoMap = new HashMap();
        HashMap<String, Set<InstanceConfig>> stateInfoMap = new HashMap();

        public void addEntry(String stateUnitKey, String state, InstanceConfig config) {
            if (!this.stateInfoMap.containsKey(state)) {
                Comparator<InstanceConfig> comparator = new Comparator<InstanceConfig>(){

                    @Override
                    public int compare(InstanceConfig o1, InstanceConfig o2) {
                        if (o1 == o2) {
                            return 0;
                        }
                        if (o1 == null) {
                            return -1;
                        }
                        if (o2 == null) {
                            return 1;
                        }
                        int compareTo = o1.getHostName().compareTo(o2.getHostName());
                        if (compareTo == 0) {
                            return o1.getPort().compareTo(o2.getPort());
                        }
                        return compareTo;
                    }
                };
                this.stateInfoMap.put(state, new TreeSet<InstanceConfig>(comparator));
            }
            Set<InstanceConfig> set = this.stateInfoMap.get(state);
            set.add(config);
            if (!this.partitionInfoMap.containsKey(stateUnitKey)) {
                this.partitionInfoMap.put(stateUnitKey, new PartitionInfo());
            }
            PartitionInfo stateUnitKeyInfo = this.partitionInfoMap.get(stateUnitKey);
            stateUnitKeyInfo.addEntry(state, config);
        }

        public Set<InstanceConfig> getInstances(String state) {
            Set<InstanceConfig> instanceSet = this.stateInfoMap.get(state);
            return instanceSet;
        }

        PartitionInfo get(String stateUnitKey) {
            return this.partitionInfoMap.get(stateUnitKey);
        }
    }

    class RoutingTable {
        private final HashMap<String, ResourceInfo> resourceInfoMap = new HashMap();

        public void addEntry(String resourceName, String partitionName, String state, InstanceConfig config) {
            if (!this.resourceInfoMap.containsKey(resourceName)) {
                this.resourceInfoMap.put(resourceName, new ResourceInfo());
            }
            ResourceInfo resourceInfo = this.resourceInfoMap.get(resourceName);
            resourceInfo.addEntry(partitionName, state, config);
        }

        ResourceInfo get(String resourceName) {
            return this.resourceInfoMap.get(resourceName);
        }
    }
}

