/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.utils;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ReplacingOutputStream
extends FilterOutputStream {
    private byte[] replaceFrom;
    private byte[] replaceTo;
    private int posInFrom = 0;

    public ReplacingOutputStream(OutputStream out, byte[] replaceFrom, byte[] replaceTo) {
        super(out);
        this.replaceFrom = replaceFrom;
        this.replaceTo = replaceTo;
    }

    @Override
    public void write(int b) throws IOException {
        if (b == this.replaceFrom[this.posInFrom]) {
            ++this.posInFrom;
            if (this.posInFrom == this.replaceFrom.length) {
                for (int i = 0; i < this.replaceTo.length; ++i) {
                    super.write(this.replaceTo[i]);
                }
                this.posInFrom = 0;
            }
        } else {
            for (int i = 0; i < this.posInFrom; ++i) {
                super.write(this.replaceFrom[i]);
            }
            this.posInFrom = 0;
            super.write(b);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.posInFrom == this.replaceFrom.length) {
            for (int i = 0; i < this.replaceTo.length; ++i) {
                super.write(this.replaceTo[i]);
            }
            this.posInFrom = 0;
        }
        super.close();
    }
}

