/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.impl.graphmatching;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.rdf.core.BNode;
import org.apache.clerezza.rdf.core.MGraph;
import org.apache.clerezza.rdf.core.NonLiteral;
import org.apache.clerezza.rdf.core.Resource;
import org.apache.clerezza.rdf.core.Triple;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.TripleImpl;
import org.apache.clerezza.rdf.core.impl.graphmatching.GraphNotIsomorphicException;
import org.apache.clerezza.rdf.core.impl.graphmatching.Utils;
import org.apache.clerezza.rdf.core.impl.graphmatching.collections.IntHashMap;
import org.apache.clerezza.rdf.core.impl.graphmatching.collections.IntIterator;

public class HashMatching {
    private Map<BNode, BNode> matchings = new HashMap<BNode, BNode>();
    private Map<Set<BNode>, Set<BNode>> matchingGroups;

    HashMatching(MGraph tc1, MGraph tc2) throws GraphNotIsomorphicException {
        int foundMatchings = 0;
        int foundMatchingGroups = 0;
        Map<BNode, Integer> bNodeHashMap = new HashMap<BNode, Integer>();
        while (true) {
            if ((bNodeHashMap = this.matchByHashes(tc1, tc2, bNodeHashMap)) == null) {
                throw new GraphNotIsomorphicException();
            }
            if (this.matchings.size() == foundMatchings && this.matchingGroups.size() <= foundMatchingGroups) break;
            foundMatchings = this.matchings.size();
            foundMatchingGroups = this.matchingGroups.size();
        }
    }

    public Map<Set<BNode>, Set<BNode>> getMatchingGroups() {
        return this.matchingGroups;
    }

    public Map<BNode, BNode> getMatchings() {
        return this.matchings;
    }

    private static IntHashMap<Set<BNode>> getHashNodes(Map<BNode, Set<Property>> bNodePropMap, Map<BNode, Integer> bNodeHashMap) {
        IntHashMap<Set<BNode>> result = new IntHashMap<Set<BNode>>();
        for (Map.Entry<BNode, Set<Property>> entry : bNodePropMap.entrySet()) {
            int hash = HashMatching.computeHash(entry.getValue(), bNodeHashMap);
            Set<BNode> bNodeSet = result.get(hash);
            if (bNodeSet == null) {
                bNodeSet = new HashSet<BNode>();
                result.put(hash, bNodeSet);
            }
            bNodeSet.add(entry.getKey());
        }
        return result;
    }

    private Map<BNode, Integer> matchByHashes(MGraph g1, MGraph g2, Map<BNode, Integer> bNodeHashMap) {
        Map<BNode, Set<Property>> bNodePropMap1 = HashMatching.getBNodePropMap(g1);
        Map<BNode, Set<Property>> bNodePropMap2 = HashMatching.getBNodePropMap(g2);
        IntHashMap<Set<BNode>> hashNodeMap1 = HashMatching.getHashNodes(bNodePropMap1, bNodeHashMap);
        IntHashMap<Set<BNode>> hashNodeMap2 = HashMatching.getHashNodes(bNodePropMap2, bNodeHashMap);
        if (!hashNodeMap1.keySet().equals(hashNodeMap2.keySet())) {
            return null;
        }
        this.matchingGroups = new HashMap<Set<BNode>, Set<BNode>>();
        IntIterator hashIter = hashNodeMap1.keySet().intIterator();
        while (hashIter.hasNext()) {
            int hash = (Integer)hashIter.next();
            Set<BNode> nodes1 = hashNodeMap1.get(hash);
            Set<BNode> nodes2 = hashNodeMap2.get(hash);
            if (nodes1.size() != nodes2.size()) {
                return null;
            }
            if (nodes1.size() != 1) {
                this.matchingGroups.put(nodes1, nodes2);
                continue;
            }
            BNode bNode1 = nodes1.iterator().next();
            BNode bNode2 = nodes2.iterator().next();
            this.matchings.put(bNode1, bNode2);
            MappedNode mappedNode = new MappedNode(bNode1, bNode2);
            HashMatching.replaceNode(g1, bNode1, mappedNode);
            HashMatching.replaceNode(g2, bNode2, mappedNode);
            if (Utils.removeGrounded(g1, g2)) continue;
            return null;
        }
        HashMap<BNode, Integer> result = new HashMap<BNode, Integer>();
        HashMatching.addInverted(result, hashNodeMap1);
        HashMatching.addInverted(result, hashNodeMap2);
        return result;
    }

    private static int computeHash(Set<Property> propertySet, Map<BNode, Integer> bNodeHashMap) {
        int result = 0;
        for (Property property : propertySet) {
            result += property.hashCode(bNodeHashMap);
        }
        return result;
    }

    private static Map<BNode, Set<Property>> getBNodePropMap(MGraph g) {
        Set<BNode> bNodes = Utils.getBNodes(g);
        HashMap<BNode, Set<Property>> result = new HashMap<BNode, Set<Property>>();
        for (BNode bNode : bNodes) {
            result.put(bNode, HashMatching.getProperties(bNode, g));
        }
        return result;
    }

    private static Set<Property> getProperties(BNode bNode, MGraph g) {
        Triple triple;
        HashSet<Property> result = new HashSet<Property>();
        Iterator<Triple> ti = g.filter(bNode, null, null);
        while (ti.hasNext()) {
            triple = ti.next();
            result.add(new ForwardProperty(triple.getPredicate(), triple.getObject()));
        }
        ti = g.filter(null, null, bNode);
        while (ti.hasNext()) {
            triple = ti.next();
            result.add(new BackwardProperty(triple.getSubject(), triple.getPredicate()));
        }
        return result;
    }

    private static int nodeHash(Resource resource, Map<BNode, Integer> bNodeHashMap) {
        if (resource instanceof BNode) {
            Integer mapValue = bNodeHashMap.get((BNode)resource);
            if (mapValue == null) {
                return 0;
            }
            return mapValue;
        }
        return resource.hashCode();
    }

    private static void replaceNode(MGraph mGraph, BNode bNode, NonLiteral replacementNode) {
        HashSet<Triple> triplesToRemove = new HashSet<Triple>();
        for (Triple triple : mGraph) {
            Triple replacementTriple = HashMatching.getReplacement(triple, bNode, replacementNode);
            if (replacementTriple == null) continue;
            triplesToRemove.add(triple);
            mGraph.add(replacementTriple);
        }
        mGraph.removeAll(triplesToRemove);
    }

    private static Triple getReplacement(Triple triple, BNode bNode, NonLiteral replacementNode) {
        if (triple.getSubject().equals(bNode)) {
            if (triple.getObject().equals(bNode)) {
                return new TripleImpl(replacementNode, triple.getPredicate(), replacementNode);
            }
            return new TripleImpl(replacementNode, triple.getPredicate(), triple.getObject());
        }
        if (triple.getObject().equals(bNode)) {
            return new TripleImpl(triple.getSubject(), triple.getPredicate(), replacementNode);
        }
        return null;
    }

    private static void addInverted(Map<BNode, Integer> result, IntHashMap<Set<BNode>> hashNodeMap) {
        Iterator i$ = hashNodeMap.keySet().iterator();
        while (i$.hasNext()) {
            int hash = (Integer)i$.next();
            Set<BNode> bNodes = hashNodeMap.get(hash);
            for (BNode bNode : bNodes) {
                result.put(bNode, hash);
            }
        }
    }

    private static interface Property {
        public int hashCode(Map<BNode, Integer> var1);
    }

    private static class MappedNode
    implements NonLiteral {
        private BNode bNode1;
        private BNode bNode2;

        public MappedNode(BNode bNode1, BNode bNode2) {
            this.bNode1 = bNode1;
            this.bNode2 = bNode2;
        }
    }

    private static class ForwardProperty
    implements Property {
        private UriRef predicate;
        private Resource object;

        public ForwardProperty(UriRef predicate, Resource object) {
            this.predicate = predicate;
            this.object = object;
        }

        @Override
        public int hashCode(Map<BNode, Integer> bNodeHashMap) {
            return this.predicate.hashCode() ^ HashMatching.nodeHash(this.object, bNodeHashMap);
        }
    }

    private static class BackwardProperty
    implements Property {
        private NonLiteral subject;
        private UriRef predicate;

        public BackwardProperty(NonLiteral subject, UriRef predicate) {
            this.subject = subject;
            this.predicate = predicate;
        }

        @Override
        public int hashCode(Map<BNode, Integer> bNodeHashMap) {
            return 0xFF ^ this.predicate.hashCode() ^ HashMatching.nodeHash(this.subject, bNodeHashMap);
        }
    }
}

