/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.impl.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class W3CDateFormat
extends DateFormat {
    public static final W3CDateFormat instance = new W3CDateFormat();
    private static final SimpleDateFormat dateFormatWithMillis = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    private static final SimpleDateFormat dateFormatNoMillis = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private static final long serialVersionUID = 3258407344076372025L;
    private static final TimeZone utcTZ = new SimpleTimeZone(0, "UTC");

    @Override
    public void setTimeZone(TimeZone zone) {
        super.setTimeZone(zone);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        SimpleDateFormat dateFormat = date.getTime() % 1000L == 0L ? dateFormatNoMillis : dateFormatWithMillis;
        String string = dateFormat.format(date);
        if (string.endsWith("0000")) {
            StringBuffer result = new StringBuffer(string.substring(0, string.length() - 5));
            result.append('Z');
            return result;
        }
        StringBuffer result = new StringBuffer(string);
        result.insert(string.length() - 2, ':');
        return result;
    }

    @Override
    public Date parse(String dateString, ParsePosition parsePos) {
        char tzd1;
        int position = parsePos.getIndex();
        int y1 = dateString.charAt(position++) - 48;
        int y2 = dateString.charAt(position++) - 48;
        int y3 = dateString.charAt(position++) - 48;
        int y4 = dateString.charAt(position++) - 48;
        int year = 1000 * y1 + 100 * y2 + 10 * y3 + y4;
        int n = ++position;
        int m1 = dateString.charAt(n) - 48;
        int n2 = ++position;
        ++position;
        int m2 = dateString.charAt(n2) - 48;
        int month = 10 * m1 + m2;
        int n3 = ++position;
        int d1 = dateString.charAt(n3) - 48;
        int n4 = ++position;
        ++position;
        int d2 = dateString.charAt(n4) - 48;
        int day = 10 * d1 + d2;
        int n5 = ++position;
        int h1 = dateString.charAt(n5) - 48;
        int n6 = ++position;
        ++position;
        int h2 = dateString.charAt(n6) - 48;
        int hour = 10 * h1 + h2;
        int n7 = ++position;
        int min1 = dateString.charAt(n7) - 48;
        int n8 = ++position;
        ++position;
        int min2 = dateString.charAt(n8) - 48;
        int minutes = 10 * min1 + min2;
        int n9 = ++position;
        int s1 = dateString.charAt(n9) - 48;
        int n10 = ++position;
        int s2 = dateString.charAt(n10) - 48;
        int secs = 10 * s1 + s2;
        GregorianCalendar resultCalendar = new GregorianCalendar(year, month - 1, day, hour, minutes, secs);
        ((Calendar)resultCalendar).setTimeZone(utcTZ);
        int n11 = ++position;
        ++position;
        char afterSecChar = dateString.charAt(n11);
        int msecs = 0;
        if (afterSecChar == '.') {
            int startPos = position;
            char nextChar = dateString.charAt(position++);
            while (nextChar != 'Z' && nextChar != '-' && nextChar != '+') {
                msecs = (int)((double)msecs + (double)(nextChar - 48) * Math.pow(10.0, 3 + startPos - position));
                nextChar = dateString.charAt(position++);
            }
            tzd1 = nextChar;
        } else {
            tzd1 = afterSecChar;
        }
        long timeInMillis = resultCalendar.getTimeInMillis() + (long)msecs;
        if (tzd1 != 'Z') {
            int htz1 = dateString.charAt(position++) - 48;
            int htz2 = dateString.charAt(position++) - 48;
            int hourtz = 10 * htz1 + htz2;
            int n12 = ++position;
            int mintz1 = dateString.charAt(n12) - 48;
            int n13 = ++position;
            ++position;
            int mintz2 = dateString.charAt(n13) - 48;
            int minutestz = 10 * mintz1 + mintz2;
            int offSetInMillis = (hourtz * 60 + minutestz) * 60000;
            timeInMillis = tzd1 == '+' ? (timeInMillis -= (long)offSetInMillis) : (timeInMillis += (long)offSetInMillis);
        }
        parsePos.setIndex(position);
        return new Date(timeInMillis);
    }

    static {
        dateFormatWithMillis.setTimeZone(utcTZ);
        dateFormatNoMillis.setTimeZone(utcTZ);
    }
}

