/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.menu;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.uberfire.client.mvp.UberView;
import org.uberfire.client.workbench.events.PerspectiveChange;
import org.uberfire.client.workbench.events.PlaceMaximizedEvent;
import org.uberfire.client.workbench.events.PlaceMinimizedEvent;
import org.uberfire.client.workbench.widgets.menu.WorkbenchMenuBar;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

@Dependent
public class WorkbenchViewModeSwitcherPresenter
implements IsWidget {
    public static final String SWITCH_TO_DEFAULT_VIEW = "Switch to Default View";
    public static final String SWITCH_TO_COMPACT_VIEW = "Switch to Compact View";
    private final WorkbenchMenuBar menubar;
    private Command collapseCommand;
    private Command expandCommand;
    private final View view;

    @Inject
    public WorkbenchViewModeSwitcherPresenter(final View view, final WorkbenchMenuBar menubar) {
        this.view = (View)PortablePreconditions.checkNotNull((String)"view", (Object)view);
        this.menubar = (WorkbenchMenuBar)PortablePreconditions.checkNotNull((String)"menubar", (Object)menubar);
        view.init(this);
        view.setText(SWITCH_TO_COMPACT_VIEW);
        view.addClickHandler(new Command(){

            public void execute() {
                if (menubar.isExpanded()) {
                    menubar.collapse();
                    if (WorkbenchViewModeSwitcherPresenter.this.collapseCommand != null) {
                        WorkbenchViewModeSwitcherPresenter.this.collapseCommand.execute();
                    }
                } else {
                    menubar.expand();
                    if (WorkbenchViewModeSwitcherPresenter.this.expandCommand != null) {
                        WorkbenchViewModeSwitcherPresenter.this.expandCommand.execute();
                    }
                }
            }
        });
        menubar.addCollapseHandler(new Command(){

            public void execute() {
                view.setText(WorkbenchViewModeSwitcherPresenter.SWITCH_TO_DEFAULT_VIEW);
            }
        });
        menubar.addExpandHandler(new Command(){

            public void execute() {
                view.setText(WorkbenchViewModeSwitcherPresenter.SWITCH_TO_COMPACT_VIEW);
            }
        });
    }

    public void setCollapseHandler(Command command) {
        this.collapseCommand = command;
    }

    public void setExpandHandler(Command command) {
        this.expandCommand = command;
    }

    protected void onPerspectiveChange(@Observes PerspectiveChange perspectiveChange) {
        this.view.enable();
    }

    protected void onPlaceMinimized(@Observes PlaceMinimizedEvent event) {
        this.view.enable();
    }

    protected void onPlaceMaximized(@Observes PlaceMaximizedEvent event) {
        this.view.disable();
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    public static interface View
    extends UberView<WorkbenchViewModeSwitcherPresenter> {
        public void setText(String var1);

        public void enable();

        public void disable();

        public void addClickHandler(Command var1);
    }
}

