/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.ext.beans;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import org.uberfire.relocated.freemarker.ext.beans.MemberAndArguments;
import org.uberfire.relocated.freemarker.ext.beans.MethodMap;
import org.uberfire.relocated.freemarker.template.SimpleNumber;
import org.uberfire.relocated.freemarker.template.TemplateMethodModelEx;
import org.uberfire.relocated.freemarker.template.TemplateModel;
import org.uberfire.relocated.freemarker.template.TemplateModelException;
import org.uberfire.relocated.freemarker.template.TemplateSequenceModel;
import org.uberfire.relocated.freemarker.template.utility.Collections12;

class OverloadedMethodModel
implements TemplateMethodModelEx,
TemplateSequenceModel {
    private final Object object;
    private final MethodMap methodMap;

    public OverloadedMethodModel(Object object, MethodMap methodMap) {
        this.object = object;
        this.methodMap = methodMap;
    }

    public Object exec(List arguments) throws TemplateModelException {
        MemberAndArguments maa = this.methodMap.getMemberAndArguments(arguments);
        Method method = (Method)maa.getMember();
        try {
            return this.methodMap.getWrapper().invokeMethod(this.object, method, maa.getArgs());
        }
        catch (Exception e) {
            Throwable t;
            while (e instanceof InvocationTargetException && (t = ((InvocationTargetException)e).getTargetException()) instanceof Exception) {
                e = (Exception)t;
            }
            if ((method.getModifiers() & 8) != 0) {
                throw new TemplateModelException("Method " + method + " threw an exception", e);
            }
            StringBuffer buf = new StringBuffer();
            Object[] args = maa.getArgs();
            for (int i = 0; i < args.length; ++i) {
                Object arg = args[i];
                buf.append(arg == null ? "null" : arg.getClass().getName()).append(',');
            }
            throw new TemplateModelException("Method " + method + " threw an exception when invoked on " + this.object + " with arguments of types [" + buf + "]", e);
        }
    }

    public TemplateModel get(int index) throws TemplateModelException {
        return (TemplateModel)this.exec(Collections12.singletonList(new SimpleNumber(new Integer(index))));
    }

    public int size() throws TemplateModelException {
        throw new TemplateModelException("?size is unsupported for: " + this.getClass().getName());
    }
}

