/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.security.impl.authz;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Alternative;
import org.jboss.errai.security.shared.api.identity.User;
import org.jboss.errai.security.shared.exception.UnauthorizedException;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.security.Resource;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.AuthorizationResult;
import org.uberfire.security.authz.ProfileDecisionManager;
import org.uberfire.security.impl.authz.DefaultProfileDecisionManager;
import org.uberfire.security.impl.authz.RuntimeResourceDecisionManager;
import org.uberfire.security.impl.authz.RuntimeResourceManager;

@ApplicationScoped
@Alternative
public class RuntimeAuthorizationManager
implements AuthorizationManager {
    private final RuntimeResourceManager resourceManager = new RuntimeResourceManager();
    private final RuntimeResourceDecisionManager decisionManager = new RuntimeResourceDecisionManager(this.resourceManager);
    private final ProfileDecisionManager profileDecisionManager = new DefaultProfileDecisionManager();

    public boolean supports(Resource resource) {
        return this.resourceManager.supports(resource);
    }

    public boolean authorize(Resource resource, User user) throws UnauthorizedException {
        if (!this.resourceManager.requiresAuthentication(resource)) {
            return true;
        }
        PortablePreconditions.checkNotNull((String)"subject", (Object)user);
        AuthorizationResult finalResult = this.decisionManager.decide(resource, user, this.profileDecisionManager);
        return finalResult.equals(AuthorizationResult.ACCESS_ABSTAIN) || finalResult.equals(AuthorizationResult.ACCESS_GRANTED);
    }

    public String toString() {
        return "RuntimeAuthorizationManager [resourceManager=" + this.resourceManager + ", decisionManager=" + this.decisionManager + ", profileDecisionManager=" + this.profileDecisionManager + "]";
    }
}

