/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.impl;

import java.math.BigInteger;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.clerezza.rdf.core.InvalidLiteralTypeException;
import org.apache.clerezza.rdf.core.LiteralFactory;
import org.apache.clerezza.rdf.core.NoConvertorException;
import org.apache.clerezza.rdf.core.TypedLiteral;
import org.apache.clerezza.rdf.core.UriRef;
import org.apache.clerezza.rdf.core.impl.TypedLiteralImpl;
import org.apache.clerezza.rdf.core.impl.util.Base64;
import org.apache.clerezza.rdf.core.impl.util.W3CDateFormat;

public class SimpleLiteralFactory
extends LiteralFactory {
    private static final String XSD = "http://www.w3.org/2001/XMLSchema#";
    private static final UriRef xsdInteger = SimpleLiteralFactory.xsd("integer");
    private static final UriRef xsdInt = SimpleLiteralFactory.xsd("int");
    private static final UriRef xsdShort = SimpleLiteralFactory.xsd("short");
    private static final UriRef xsdByte = SimpleLiteralFactory.xsd("byte");
    private static final UriRef xsdLong = SimpleLiteralFactory.xsd("long");
    private static final Set<UriRef> decimalTypes = new HashSet<UriRef>();
    private static final Map<Class<?>, TypeConverter<?>> typeConverterMap = new HashMap();
    static final Class<? extends byte[]> byteArrayType;
    private static final UriRef xsdDouble;
    private static final UriRef xsdFloat;
    private static final UriRef xsdAnyURI;

    private static final UriRef xsd(String name) {
        return new UriRef(XSD + name);
    }

    @Override
    public TypedLiteral createTypedLiteral(Object value) throws NoConvertorException {
        TypeConverter<?> converter = this.getConverterFor(value.getClass());
        return converter.createTypedLiteral(value);
    }

    @Override
    public <T> T createObject(Class<T> type, TypedLiteral literal) throws NoConvertorException, InvalidLiteralTypeException {
        TypeConverter<T> converter = this.getConverterFor(type);
        return converter.createObject(literal);
    }

    private <T> TypeConverter<T> getConverterFor(Class<T> type) throws NoConvertorException {
        TypeConverter<?> convertor = typeConverterMap.get(type);
        if (convertor != null) {
            return convertor;
        }
        for (Map.Entry<Class<?>, TypeConverter<?>> converterEntry : typeConverterMap.entrySet()) {
            if (!type.isAssignableFrom(converterEntry.getKey())) continue;
            return converterEntry.getValue();
        }
        throw new NoConvertorException(type);
    }

    static /* synthetic */ UriRef access$1000(String x0) {
        return SimpleLiteralFactory.xsd(x0);
    }

    static {
        Collections.addAll(decimalTypes, xsdInteger, xsdInt, xsdByte, xsdShort, xsdLong);
        byte[] byteArray = new byte[]{};
        byteArrayType = byteArray.getClass();
        typeConverterMap.put(byteArrayType, new ByteArrayConverter());
        typeConverterMap.put(Date.class, new DateConverter());
        typeConverterMap.put(Boolean.class, new BooleanConverter());
        typeConverterMap.put(String.class, new StringConverter());
        typeConverterMap.put(Integer.class, new IntegerConverter());
        typeConverterMap.put(BigInteger.class, new BigIntegerConverter());
        typeConverterMap.put(Long.class, new LongConverter());
        typeConverterMap.put(Double.class, new DoubleConverter());
        typeConverterMap.put(Float.class, new FloatConverter());
        typeConverterMap.put(UriRef.class, new UriRefConverter());
        xsdDouble = SimpleLiteralFactory.xsd("double");
        xsdFloat = SimpleLiteralFactory.xsd("float");
        xsdAnyURI = SimpleLiteralFactory.xsd("anyURI");
    }

    private static class UriRefConverter
    implements TypeConverter<UriRef> {
        private UriRefConverter() {
        }

        @Override
        public TypedLiteral createTypedLiteral(UriRef value) {
            return new TypedLiteralImpl(value.getUnicodeString(), xsdAnyURI);
        }

        @Override
        public UriRef createObject(TypedLiteral literal) {
            if (!literal.getDataType().equals(xsdAnyURI)) {
                throw new InvalidLiteralTypeException(UriRef.class, literal.getDataType());
            }
            return new UriRef(literal.getLexicalForm());
        }
    }

    private static class BigIntegerConverter
    implements TypeConverter<BigInteger> {
        private BigIntegerConverter() {
        }

        @Override
        public TypedLiteral createTypedLiteral(BigInteger value) {
            return new TypedLiteralImpl(value.toString(), xsdInteger);
        }

        @Override
        public BigInteger createObject(TypedLiteral literal) {
            if (!literal.getDataType().equals(xsdInteger)) {
                throw new InvalidLiteralTypeException(Double.class, literal.getDataType());
            }
            return new BigInteger(literal.getLexicalForm());
        }
    }

    private static class DoubleConverter
    implements TypeConverter<Double> {
        private DoubleConverter() {
        }

        @Override
        public TypedLiteral createTypedLiteral(Double value) {
            return new TypedLiteralImpl(value.toString(), xsdDouble);
        }

        @Override
        public Double createObject(TypedLiteral literal) {
            if (!literal.getDataType().equals(xsdDouble)) {
                throw new InvalidLiteralTypeException(Double.class, literal.getDataType());
            }
            return new Double(literal.getLexicalForm());
        }
    }

    private static class FloatConverter
    implements TypeConverter<Float> {
        private FloatConverter() {
        }

        @Override
        public TypedLiteral createTypedLiteral(Float value) {
            return new TypedLiteralImpl(value.toString(), xsdFloat);
        }

        @Override
        public Float createObject(TypedLiteral literal) {
            if (!literal.getDataType().equals(xsdFloat)) {
                throw new InvalidLiteralTypeException(Float.class, literal.getDataType());
            }
            return Float.valueOf(literal.getLexicalForm());
        }
    }

    private static class LongConverter
    implements TypeConverter<Long> {
        private LongConverter() {
        }

        @Override
        public TypedLiteral createTypedLiteral(Long value) {
            return new TypedLiteralImpl(value.toString(), xsdLong);
        }

        @Override
        public Long createObject(TypedLiteral literal) {
            if (!decimalTypes.contains(literal.getDataType())) {
                throw new InvalidLiteralTypeException(Long.class, literal.getDataType());
            }
            return new Long(literal.getLexicalForm());
        }
    }

    private static class IntegerConverter
    implements TypeConverter<Integer> {
        private IntegerConverter() {
        }

        @Override
        public TypedLiteral createTypedLiteral(Integer value) {
            return new TypedLiteralImpl(value.toString(), xsdInt);
        }

        @Override
        public Integer createObject(TypedLiteral literal) {
            if (!decimalTypes.contains(literal.getDataType())) {
                throw new InvalidLiteralTypeException(Integer.class, literal.getDataType());
            }
            return new Integer(literal.getLexicalForm());
        }
    }

    private static class StringConverter
    implements TypeConverter<String> {
        private static final UriRef stringUri = SimpleLiteralFactory.access$1000("string");

        private StringConverter() {
        }

        @Override
        public TypedLiteral createTypedLiteral(String value) {
            return new TypedLiteralImpl(value, stringUri);
        }

        @Override
        public String createObject(TypedLiteral literal) {
            if (!literal.getDataType().equals(stringUri)) {
                throw new InvalidLiteralTypeException(String.class, literal.getDataType());
            }
            return literal.getLexicalForm();
        }
    }

    private static class BooleanConverter
    implements TypeConverter<Boolean> {
        private static final UriRef booleanUri = SimpleLiteralFactory.access$1000("boolean");
        public static final TypedLiteralImpl TRUE = new TypedLiteralImpl("true", booleanUri);
        public static final TypedLiteralImpl FALSE = new TypedLiteralImpl("false", booleanUri);

        private BooleanConverter() {
        }

        @Override
        public TypedLiteral createTypedLiteral(Boolean value) {
            if (value.booleanValue()) {
                return TRUE;
            }
            return FALSE;
        }

        @Override
        public Boolean createObject(TypedLiteral literal) {
            if (literal == TRUE) {
                return true;
            }
            if (literal == FALSE) {
                return false;
            }
            if (!literal.getDataType().equals(booleanUri)) {
                throw new InvalidLiteralTypeException(Boolean.class, literal.getDataType());
            }
            return Boolean.valueOf(literal.getLexicalForm());
        }
    }

    private static class DateConverter
    implements TypeConverter<Date> {
        private static final UriRef dateTimeUri = SimpleLiteralFactory.access$1000("dateTime");
        private static final DateFormat DATE_FORMAT = new W3CDateFormat();

        private DateConverter() {
        }

        @Override
        public TypedLiteral createTypedLiteral(Date value) {
            return new TypedLiteralImpl(DATE_FORMAT.format(value), dateTimeUri);
        }

        @Override
        public Date createObject(TypedLiteral literal) {
            if (!literal.getDataType().equals(dateTimeUri)) {
                throw new InvalidLiteralTypeException(Date.class, literal.getDataType());
            }
            try {
                return DATE_FORMAT.parse(literal.getLexicalForm());
            }
            catch (ParseException ex) {
                throw new RuntimeException("Exception parsing literal as date", ex);
            }
        }
    }

    private static class ByteArrayConverter
    implements TypeConverter<byte[]> {
        private static final UriRef base64Uri = SimpleLiteralFactory.access$1000("base64Binary");

        private ByteArrayConverter() {
        }

        @Override
        public TypedLiteral createTypedLiteral(byte[] value) {
            return new TypedLiteralImpl(Base64.encode(value), base64Uri);
        }

        @Override
        public byte[] createObject(TypedLiteral literal) {
            if (!literal.getDataType().equals(base64Uri)) {
                throw new InvalidLiteralTypeException(byteArrayType, literal.getDataType());
            }
            return Base64.decode(literal.getLexicalForm());
        }
    }

    private static interface TypeConverter<T> {
        public TypedLiteral createTypedLiteral(T var1);

        public T createObject(TypedLiteral var1);
    }
}

