/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.I0Itec.zkclient.DataUpdater;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.apache.helix.AccessOption;
import org.apache.helix.ConfigAccessor;
import org.apache.helix.HelixAdmin;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixException;
import org.apache.helix.InstanceType;
import org.apache.helix.PropertyKey;
import org.apache.helix.PropertyPathConfig;
import org.apache.helix.PropertyType;
import org.apache.helix.ZNRecord;
import org.apache.helix.manager.zk.ZKHelixDataAccessor;
import org.apache.helix.manager.zk.ZKUtil;
import org.apache.helix.manager.zk.ZNRecordSerializer;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.helix.manager.zk.ZkClient;
import org.apache.helix.model.ClusterConstraints;
import org.apache.helix.model.ConstraintItem;
import org.apache.helix.model.CurrentState;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.HelixConfigScope;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Message;
import org.apache.helix.model.PauseSignal;
import org.apache.helix.model.StateModelDefinition;
import org.apache.helix.tools.DefaultIdealStateCalculator;
import org.apache.helix.util.HelixUtil;
import org.apache.helix.util.RebalanceUtil;
import org.apache.log4j.Logger;

public class ZKHelixAdmin
implements HelixAdmin {
    public static final String CONNECTION_TIMEOUT = "helixAdmin.timeOutInSec";
    private final ZkClient _zkClient;
    private final ConfigAccessor _configAccessor;
    private static Logger logger = Logger.getLogger(ZKHelixAdmin.class);

    public ZKHelixAdmin(ZkClient zkClient) {
        this._zkClient = zkClient;
        this._configAccessor = new ConfigAccessor(zkClient);
    }

    public ZKHelixAdmin(String zkAddress) {
        int timeOutInSec = Integer.parseInt(System.getProperty(CONNECTION_TIMEOUT, "30"));
        this._zkClient = new ZkClient(zkAddress, timeOutInSec * 1000);
        this._zkClient.setZkSerializer(new ZNRecordSerializer());
        this._zkClient.waitUntilConnected(timeOutInSec, TimeUnit.SECONDS);
        this._configAccessor = new ConfigAccessor(this._zkClient);
    }

    @Override
    public void addInstance(String clusterName, InstanceConfig instanceConfig) {
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        String instanceConfigsPath = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString());
        String nodeId = instanceConfig.getId();
        String instanceConfigPath = instanceConfigsPath + "/" + nodeId;
        if (this._zkClient.exists(instanceConfigPath)) {
            throw new HelixException("Node " + nodeId + " already exists in cluster " + clusterName);
        }
        ZKUtil.createChildren(this._zkClient, instanceConfigsPath, instanceConfig.getRecord());
        this._zkClient.createPersistent(HelixUtil.getMessagePath(clusterName, nodeId), true);
        this._zkClient.createPersistent(HelixUtil.getCurrentStateBasePath(clusterName, nodeId), true);
        this._zkClient.createPersistent(HelixUtil.getErrorsPath(clusterName, nodeId), true);
        this._zkClient.createPersistent(HelixUtil.getStatusUpdatesPath(clusterName, nodeId), true);
    }

    @Override
    public void dropInstance(String clusterName, InstanceConfig instanceConfig) {
        String instanceConfigsPath = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString());
        String nodeId = instanceConfig.getId();
        String instanceConfigPath = instanceConfigsPath + "/" + nodeId;
        String instancePath = HelixUtil.getInstancePath(clusterName, nodeId);
        if (!this._zkClient.exists(instanceConfigPath)) {
            throw new HelixException("Node " + nodeId + " does not exist in config for cluster " + clusterName);
        }
        if (!this._zkClient.exists(instancePath)) {
            throw new HelixException("Node " + nodeId + " does not exist in instances for cluster " + clusterName);
        }
        ZKUtil.dropChildren(this._zkClient, instanceConfigsPath, instanceConfig.getRecord());
        this._zkClient.deleteRecursive(instancePath);
    }

    @Override
    public InstanceConfig getInstanceConfig(String clusterName, String instanceName) {
        String instanceConfigPath = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString(), instanceName);
        if (!this._zkClient.exists(instanceConfigPath)) {
            throw new HelixException("instance" + instanceName + " does not exist in cluster " + clusterName);
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return (InstanceConfig)accessor.getProperty(keyBuilder.instanceConfig(instanceName));
    }

    @Override
    public void enableInstance(final String clusterName, final String instanceName, final boolean enabled) {
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        String path = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString(), instanceName);
        if (!baseAccessor.exists(path, 0)) {
            throw new HelixException("Cluster " + clusterName + ", instance: " + instanceName + ", instance config does not exist");
        }
        baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                if (currentData == null) {
                    throw new HelixException("Cluster: " + clusterName + ", instance: " + instanceName + ", participant config is null");
                }
                InstanceConfig config = new InstanceConfig(currentData);
                config.setInstanceEnabled(enabled);
                return config.getRecord();
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public void enableResource(final String clusterName, final String resourceName, final boolean enabled) {
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        String path = PropertyPathConfig.getPath(PropertyType.IDEALSTATES, clusterName, resourceName);
        if (!baseAccessor.exists(path, 0)) {
            throw new HelixException("Cluster " + clusterName + ", resource: " + resourceName + ", ideal-state does not exist");
        }
        baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                if (currentData == null) {
                    throw new HelixException("Cluster: " + clusterName + ", resource: " + resourceName + ", ideal-state is null");
                }
                IdealState idealState = new IdealState(currentData);
                idealState.enable(enabled);
                return idealState.getRecord();
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public void enablePartition(final boolean enabled, final String clusterName, final String instanceName, String resourceName, final List<String> partitionNames) {
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        String path = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString(), instanceName);
        if (!baseAccessor.exists(path, 0)) {
            throw new HelixException("Cluster: " + clusterName + ", instance: " + instanceName + ", instance config does not exist");
        }
        String idealStatePath = PropertyPathConfig.getPath(PropertyType.IDEALSTATES, clusterName, resourceName);
        ZNRecord idealStateRecord = null;
        try {
            idealStateRecord = (ZNRecord)baseAccessor.get(idealStatePath, null, 0);
        }
        catch (ZkNoNodeException e) {
            // empty catch block
        }
        if (idealStateRecord == null) {
            logger.warn((Object)("Disable partitions: " + partitionNames + " but Cluster: " + clusterName + ", resource: " + resourceName + " does not exists. probably disable it during ERROR->DROPPED transtition"));
        } else {
            IdealState idealState = new IdealState(idealStateRecord);
            for (String partitionName : partitionNames) {
                if (!(idealState.getRebalanceMode() == IdealState.RebalanceMode.SEMI_AUTO && idealState.getPreferenceList(partitionName) == null || idealState.getRebalanceMode() == IdealState.RebalanceMode.USER_DEFINED && idealState.getPreferenceList(partitionName) == null || idealState.getRebalanceMode() == IdealState.RebalanceMode.TASK && idealState.getPreferenceList(partitionName) == null) && (idealState.getRebalanceMode() != IdealState.RebalanceMode.CUSTOMIZED || idealState.getInstanceStateMap(partitionName) != null)) continue;
                logger.warn((Object)("Cluster: " + clusterName + ", resource: " + resourceName + ", partition: " + partitionName + ", partition does not exist in ideal state"));
            }
        }
        baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                if (currentData == null) {
                    throw new HelixException("Cluster: " + clusterName + ", instance: " + instanceName + ", participant config is null");
                }
                List<String> list = currentData.getListField(InstanceConfig.InstanceConfigProperty.HELIX_DISABLED_PARTITION.toString());
                HashSet<String> disabledPartitions = new HashSet<String>();
                if (list != null) {
                    disabledPartitions.addAll(list);
                }
                if (enabled) {
                    disabledPartitions.removeAll(partitionNames);
                } else {
                    disabledPartitions.addAll(partitionNames);
                }
                list = new ArrayList<String>(disabledPartitions);
                Collections.sort(list);
                currentData.setListField(InstanceConfig.InstanceConfigProperty.HELIX_DISABLED_PARTITION.toString(), list);
                return currentData;
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public void enableCluster(String clusterName, boolean enabled) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        if (enabled) {
            accessor.removeProperty(keyBuilder.pause());
        } else {
            accessor.createProperty(keyBuilder.pause(), new PauseSignal("pause"));
        }
    }

    @Override
    public void resetPartition(String clusterName, String instanceName, String resourceName, List<String> partitionNames) {
        HashSet<String> partitions;
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        LiveInstance liveInstance = (LiveInstance)accessor.getProperty(keyBuilder.liveInstance(instanceName));
        if (liveInstance == null) {
            throw new HelixException("Can't reset state for " + resourceName + "/" + partitionNames + " on " + instanceName + ", because " + instanceName + " is not alive");
        }
        IdealState idealState = (IdealState)accessor.getProperty(keyBuilder.idealStates(resourceName));
        if (idealState == null) {
            throw new HelixException("Can't reset state for " + resourceName + "/" + partitionNames + " on " + instanceName + ", because " + resourceName + " is not added");
        }
        HashSet<String> resetPartitionNames = new HashSet<String>(partitionNames);
        if (idealState.getRebalanceMode() == IdealState.RebalanceMode.CUSTOMIZED ? !(partitions = new HashSet<String>(idealState.getRecord().getMapFields().keySet())).containsAll(resetPartitionNames) : !(partitions = new HashSet<String>(idealState.getRecord().getListFields().keySet())).containsAll(resetPartitionNames)) {
            throw new HelixException("Can't reset state for " + resourceName + "/" + partitionNames + " on " + instanceName + ", because not all " + partitionNames + " exist");
        }
        String sessionId = liveInstance.getSessionId();
        CurrentState curState = (CurrentState)accessor.getProperty(keyBuilder.currentState(instanceName, sessionId, resourceName));
        for (String partitionName : resetPartitionNames) {
            if (curState.getState(partitionName).equals(HelixDefinedState.ERROR.toString())) continue;
            throw new HelixException("Can't reset state for " + resourceName + "/" + partitionNames + " on " + instanceName + ", because not all " + partitionNames + " are in ERROR state");
        }
        String stateModelDef = idealState.getStateModelDefRef();
        StateModelDefinition stateModel = (StateModelDefinition)accessor.getProperty(keyBuilder.stateModelDef(stateModelDef));
        if (stateModel == null) {
            throw new HelixException("Can't reset state for " + resourceName + "/" + partitionNames + " on " + instanceName + ", because " + stateModelDef + " is NOT found");
        }
        List messages = accessor.getChildValues(keyBuilder.messages(instanceName));
        for (Message message : messages) {
            if (!Message.MessageType.STATE_TRANSITION.toString().equalsIgnoreCase(message.getMsgType()) || !sessionId.equals(message.getTgtSessionId()) || !resourceName.equals(message.getResourceName()) || !resetPartitionNames.contains(message.getPartitionName())) continue;
            throw new HelixException("Can't reset state for " + resourceName + "/" + partitionNames + " on " + instanceName + ", because a pending message exists: " + message);
        }
        String adminName = null;
        try {
            adminName = InetAddress.getLocalHost().getCanonicalHostName() + "-ADMIN";
        }
        catch (UnknownHostException e) {
            logger.info((Object)"Unable to get host name. Will set it to UNKNOWN, mostly ignorable", (Throwable)e);
            adminName = "UNKNOWN";
        }
        ArrayList<Message> resetMessages = new ArrayList<Message>();
        ArrayList<PropertyKey> messageKeys = new ArrayList<PropertyKey>();
        for (String partitionName : resetPartitionNames) {
            String msgId = UUID.randomUUID().toString();
            Message message = new Message(Message.MessageType.STATE_TRANSITION, msgId);
            message.setSrcName(adminName);
            message.setTgtName(instanceName);
            message.setMsgState(Message.MessageState.NEW);
            message.setPartitionName(partitionName);
            message.setResourceName(resourceName);
            message.setTgtSessionId(sessionId);
            message.setStateModelDef(stateModelDef);
            message.setFromState(HelixDefinedState.ERROR.toString());
            message.setToState(stateModel.getInitialState());
            message.setStateModelFactoryName(idealState.getStateModelFactoryName());
            resetMessages.add(message);
            messageKeys.add(keyBuilder.message(instanceName, message.getId()));
        }
        accessor.setChildren(messageKeys, resetMessages);
    }

    @Override
    public void resetInstance(String clusterName, List<String> instanceNames) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        List extViews = accessor.getChildValues(keyBuilder.externalViews());
        HashSet<String> resetInstanceNames = new HashSet<String>(instanceNames);
        for (String instanceName : resetInstanceNames) {
            ArrayList<String> resetPartitionNames = new ArrayList<String>();
            for (ExternalView extView : extViews) {
                Map<String, Map<String, String>> stateMap = extView.getRecord().getMapFields();
                for (String partitionName : stateMap.keySet()) {
                    Map<String, String> instanceStateMap = stateMap.get(partitionName);
                    if (!instanceStateMap.containsKey(instanceName) || !instanceStateMap.get(instanceName).equals(HelixDefinedState.ERROR.toString())) continue;
                    resetPartitionNames.add(partitionName);
                }
                this.resetPartition(clusterName, instanceName, extView.getResourceName(), resetPartitionNames);
            }
        }
    }

    @Override
    public void resetResource(String clusterName, List<String> resourceNames) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        List extViews = accessor.getChildValues(keyBuilder.externalViews());
        HashSet<String> resetResourceNames = new HashSet<String>(resourceNames);
        for (ExternalView extView : extViews) {
            if (!resetResourceNames.contains(extView.getResourceName())) continue;
            HashMap resetPartitionNames = new HashMap();
            Map<String, Map<String, String>> stateMap = extView.getRecord().getMapFields();
            for (String partitionName : stateMap.keySet()) {
                Map<String, String> instanceStateMap = stateMap.get(partitionName);
                for (String instanceName : instanceStateMap.keySet()) {
                    if (!instanceStateMap.get(instanceName).equals(HelixDefinedState.ERROR.toString())) continue;
                    if (!resetPartitionNames.containsKey(instanceName)) {
                        resetPartitionNames.put(instanceName, new ArrayList());
                    }
                    ((List)resetPartitionNames.get(instanceName)).add(partitionName);
                }
            }
            for (String instanceName : resetPartitionNames.keySet()) {
                this.resetPartition(clusterName, instanceName, extView.getResourceName(), (List)resetPartitionNames.get(instanceName));
            }
        }
    }

    @Override
    public boolean addCluster(String clusterName) {
        return this.addCluster(clusterName, false);
    }

    @Override
    public boolean addCluster(String clusterName, boolean recreateIfExists) {
        String root = "/" + clusterName;
        if (this._zkClient.exists(root)) {
            if (recreateIfExists) {
                logger.warn((Object)("Root directory exists.Cleaning the root directory:" + root));
                this._zkClient.deleteRecursive(root);
            } else {
                logger.info((Object)("Cluster " + clusterName + " already exists"));
                return true;
            }
        }
        try {
            this._zkClient.createPersistent(root, true);
        }
        catch (Exception e) {
            if (this._zkClient.exists(root)) {
                return true;
            }
            logger.error((Object)("Error creating cluster:" + clusterName), (Throwable)e);
            return false;
        }
        try {
            this.createZKPaths(clusterName);
        }
        catch (Exception e) {
            logger.error((Object)("Error creating cluster:" + clusterName), (Throwable)e);
            return false;
        }
        logger.info((Object)("Created cluster:" + clusterName));
        return true;
    }

    private void createZKPaths(String clusterName) {
        this._zkClient.createPersistent(HelixUtil.getIdealStatePath(clusterName));
        String path = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, HelixConfigScope.ConfigScopeProperty.CLUSTER.toString(), clusterName);
        this._zkClient.createPersistent(path, true);
        this._zkClient.writeData(path, new ZNRecord(clusterName));
        path = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, HelixConfigScope.ConfigScopeProperty.PARTICIPANT.toString());
        this._zkClient.createPersistent(path);
        path = PropertyPathConfig.getPath(PropertyType.CONFIGS, clusterName, HelixConfigScope.ConfigScopeProperty.RESOURCE.toString());
        this._zkClient.createPersistent(path);
        path = PropertyPathConfig.getPath(PropertyType.PROPERTYSTORE, clusterName, new String[0]);
        this._zkClient.createPersistent(path);
        this._zkClient.createPersistent(HelixUtil.getLiveInstancesPath(clusterName));
        this._zkClient.createPersistent(HelixUtil.getMemberInstancesPath(clusterName));
        this._zkClient.createPersistent(HelixUtil.getExternalViewPath(clusterName));
        this._zkClient.createPersistent(HelixUtil.getStateModelDefinitionPath(clusterName));
        this._zkClient.createPersistent(HelixUtil.getControllerPath(clusterName));
        path = PropertyPathConfig.getPath(PropertyType.HISTORY, clusterName, new String[0]);
        ZNRecord emptyHistory = new ZNRecord(PropertyType.HISTORY.toString());
        ArrayList<String> emptyList = new ArrayList<String>();
        emptyHistory.setListField(clusterName, emptyList);
        this._zkClient.createPersistent(path, emptyHistory);
        path = PropertyPathConfig.getPath(PropertyType.MESSAGES_CONTROLLER, clusterName, new String[0]);
        this._zkClient.createPersistent(path);
        path = PropertyPathConfig.getPath(PropertyType.STATUSUPDATES_CONTROLLER, clusterName, new String[0]);
        this._zkClient.createPersistent(path);
        path = PropertyPathConfig.getPath(PropertyType.ERRORS_CONTROLLER, clusterName, new String[0]);
        this._zkClient.createPersistent(path);
    }

    @Override
    public List<String> getInstancesInCluster(String clusterName) {
        String memberInstancesPath = HelixUtil.getMemberInstancesPath(clusterName);
        return this._zkClient.getChildren(memberInstancesPath);
    }

    @Override
    public List<String> getInstancesInClusterWithTag(String clusterName, String tag) {
        String memberInstancesPath = HelixUtil.getMemberInstancesPath(clusterName);
        List instances = this._zkClient.getChildren(memberInstancesPath);
        ArrayList<String> result = new ArrayList<String>();
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        for (String instanceName : instances) {
            InstanceConfig config = (InstanceConfig)accessor.getProperty(keyBuilder.instanceConfig(instanceName));
            if (!config.containsTag(tag)) continue;
            result.add(instanceName);
        }
        return result;
    }

    @Override
    public void addResource(String clusterName, String resourceName, int partitions, String stateModelRef) {
        this.addResource(clusterName, resourceName, partitions, stateModelRef, IdealState.RebalanceMode.SEMI_AUTO.toString(), 0);
    }

    @Override
    public void addResource(String clusterName, String resourceName, int partitions, String stateModelRef, String rebalancerMode) {
        this.addResource(clusterName, resourceName, partitions, stateModelRef, rebalancerMode, 0);
    }

    @Override
    public void addResource(String clusterName, String resourceName, IdealState idealstate) {
        String stateModelRef = idealstate.getStateModelDefRef();
        String stateModelDefPath = PropertyPathConfig.getPath(PropertyType.STATEMODELDEFS, clusterName, stateModelRef);
        if (!this._zkClient.exists(stateModelDefPath)) {
            throw new HelixException("State model " + stateModelRef + " not found in the cluster STATEMODELDEFS path");
        }
        String idealStatePath = HelixUtil.getIdealStatePath(clusterName);
        String resourceIdealStatePath = idealStatePath + "/" + resourceName;
        if (this._zkClient.exists(resourceIdealStatePath)) {
            throw new HelixException("Skip the operation. Resource ideal state directory already exists:" + resourceIdealStatePath);
        }
        ZKUtil.createChildren(this._zkClient, idealStatePath, idealstate.getRecord());
    }

    @Override
    public void addResource(String clusterName, String resourceName, int partitions, String stateModelRef, String rebalancerMode, int bucketSize) {
        this.addResource(clusterName, resourceName, partitions, stateModelRef, rebalancerMode, bucketSize, -1);
    }

    @Override
    public void addResource(String clusterName, String resourceName, int partitions, String stateModelRef, String rebalancerMode, int bucketSize, int maxPartitionsPerInstance) {
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        IdealState idealState = new IdealState(resourceName);
        idealState.setNumPartitions(partitions);
        idealState.setStateModelDefRef(stateModelRef);
        IdealState.RebalanceMode mode = idealState.rebalanceModeFromString(rebalancerMode, IdealState.RebalanceMode.SEMI_AUTO);
        idealState.setRebalanceMode(mode);
        idealState.setReplicas("0");
        idealState.setStateModelFactoryName("DEFAULT");
        if (maxPartitionsPerInstance > 0 && maxPartitionsPerInstance < Integer.MAX_VALUE) {
            idealState.setMaxPartitionsPerInstance(maxPartitionsPerInstance);
        }
        if (bucketSize > 0) {
            idealState.setBucketSize(bucketSize);
        }
        this.addResource(clusterName, resourceName, idealState);
    }

    @Override
    public List<String> getClusters() {
        List zkToplevelPathes = this._zkClient.getChildren("/");
        ArrayList<String> result = new ArrayList<String>();
        for (String pathName : zkToplevelPathes) {
            if (!ZKUtil.isClusterSetup(pathName, this._zkClient)) continue;
            result.add(pathName);
        }
        return result;
    }

    @Override
    public List<String> getResourcesInCluster(String clusterName) {
        return this._zkClient.getChildren(HelixUtil.getIdealStatePath(clusterName));
    }

    @Override
    public IdealState getResourceIdealState(String clusterName, String resourceName) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return (IdealState)accessor.getProperty(keyBuilder.idealStates(resourceName));
    }

    @Override
    public void setResourceIdealState(String clusterName, String resourceName, IdealState idealState) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.setProperty(keyBuilder.idealStates(resourceName), idealState);
    }

    @Override
    public ExternalView getResourceExternalView(String clusterName, String resourceName) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return (ExternalView)accessor.getProperty(keyBuilder.externalView(resourceName));
    }

    @Override
    public void addStateModelDef(String clusterName, String stateModelDef, StateModelDefinition stateModel) {
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        String stateModelDefPath = HelixUtil.getStateModelDefinitionPath(clusterName);
        String stateModelPath = stateModelDefPath + "/" + stateModelDef;
        if (this._zkClient.exists(stateModelPath)) {
            logger.warn((Object)("Skip the operation.State Model directory exists:" + stateModelPath));
            throw new HelixException("State model path " + stateModelPath + " already exists.");
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.setProperty(keyBuilder.stateModelDef(stateModel.getId()), stateModel);
    }

    @Override
    public void dropResource(String clusterName, String resourceName) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.removeProperty(keyBuilder.idealStates(resourceName));
        accessor.removeProperty(keyBuilder.resourceConfig(resourceName));
    }

    @Override
    public List<String> getStateModelDefs(String clusterName) {
        return this._zkClient.getChildren(HelixUtil.getStateModelDefinitionPath(clusterName));
    }

    @Override
    public StateModelDefinition getStateModelDef(String clusterName, String stateModelName) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        return (StateModelDefinition)accessor.getProperty(keyBuilder.stateModelDef(stateModelName));
    }

    @Override
    public void dropCluster(String clusterName) {
        logger.info((Object)("Deleting cluster " + clusterName));
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        String root = "/" + clusterName;
        if (accessor.getChildNames(keyBuilder.liveInstances()).size() > 0) {
            throw new HelixException("There are still live instances in the cluster, shut them down first.");
        }
        if (accessor.getProperty(keyBuilder.controllerLeader()) != null) {
            throw new HelixException("There are still LEADER in the cluster, shut them down first.");
        }
        this._zkClient.deleteRecursive(root);
    }

    @Override
    public void addClusterToGrandCluster(String clusterName, String grandCluster) {
        if (!ZKUtil.isClusterSetup(grandCluster, this._zkClient)) {
            throw new HelixException("Grand cluster " + grandCluster + " is not setup yet");
        }
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("Cluster " + clusterName + " is not setup yet");
        }
        IdealState idealState = new IdealState(clusterName);
        idealState.setNumPartitions(1);
        idealState.setStateModelDefRef("LeaderStandby");
        List<String> controllers = this.getInstancesInCluster(grandCluster);
        if (controllers.size() == 0) {
            throw new HelixException("Grand cluster " + grandCluster + " has no instances");
        }
        idealState.setReplicas(Integer.toString(controllers.size()));
        Collections.shuffle(controllers);
        idealState.getRecord().setListField(clusterName, controllers);
        idealState.setPartitionState(clusterName, controllers.get(0), "LEADER");
        for (int i = 1; i < controllers.size(); ++i) {
            idealState.setPartitionState(clusterName, controllers.get(i), "STANDBY");
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(grandCluster, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        accessor.setProperty(keyBuilder.idealStates(idealState.getResourceName()), idealState);
    }

    @Override
    public void setConfig(HelixConfigScope scope, Map<String, String> properties) {
        this._configAccessor.set(scope, properties);
    }

    @Override
    public Map<String, String> getConfig(HelixConfigScope scope, List<String> keys) {
        return this._configAccessor.get(scope, keys);
    }

    @Override
    public List<String> getConfigKeys(HelixConfigScope scope) {
        return this._configAccessor.getKeys(scope);
    }

    @Override
    public void removeConfig(HelixConfigScope scope, List<String> keys) {
        this._configAccessor.remove(scope, keys);
    }

    @Override
    public void rebalance(String clusterName, String resourceName, int replica) {
        this.rebalance(clusterName, resourceName, replica, resourceName, "");
    }

    @Override
    public void rebalance(String clusterName, String resourceName, int replica, String keyPrefix, String group) {
        LinkedList<String> instanceNames = new LinkedList();
        if (keyPrefix == null || keyPrefix.length() == 0) {
            keyPrefix = resourceName;
        }
        if (group != null && group.length() > 0) {
            instanceNames = this.getInstancesInClusterWithTag(clusterName, group);
        }
        if (instanceNames.size() == 0) {
            logger.info((Object)("No tags found for resource " + resourceName + ", use all instances"));
            instanceNames = this.getInstancesInCluster(clusterName);
            group = "";
        } else {
            logger.info((Object)("Found instances with tag for " + resourceName + " " + instanceNames));
        }
        this.rebalance(clusterName, resourceName, replica, keyPrefix, instanceNames, group);
    }

    @Override
    public void rebalance(String clusterName, String resourceName, int replica, List<String> instances) {
        this.rebalance(clusterName, resourceName, replica, resourceName, instances, "");
    }

    void rebalance(String clusterName, String resourceName, int replica, String keyPrefix, List<String> instanceNames, String groupId) {
        Collections.sort(instanceNames);
        IdealState idealState = this.getResourceIdealState(clusterName, resourceName);
        if (idealState == null) {
            throw new HelixException("Resource: " + resourceName + " has NOT been added yet");
        }
        if (groupId != null && groupId.length() > 0) {
            idealState.setInstanceGroupTag(groupId);
        }
        idealState.setReplicas(Integer.toString(replica));
        int partitions = idealState.getNumPartitions();
        String stateModelName = idealState.getStateModelDefRef();
        StateModelDefinition stateModDef = this.getStateModelDef(clusterName, stateModelName);
        if (stateModDef == null) {
            throw new HelixException("cannot find state model: " + stateModelName);
        }
        List<String> statePriorityList = stateModDef.getStatesPriorityList();
        String masterStateValue = null;
        String slaveStateValue = null;
        --replica;
        for (String state : statePriorityList) {
            String count = stateModDef.getNumInstancesPerState(state);
            if (count.equals("1")) {
                if (masterStateValue != null) {
                    throw new HelixException("Invalid or unsupported state model definition");
                }
                masterStateValue = state;
                continue;
            }
            if (count.equalsIgnoreCase("R")) {
                if (slaveStateValue != null) {
                    throw new HelixException("Invalid or unsupported state model definition");
                }
                slaveStateValue = state;
                continue;
            }
            if (!count.equalsIgnoreCase("N")) continue;
            if (masterStateValue != null || slaveStateValue != null) {
                throw new HelixException("Invalid or unsupported state model definition");
            }
            replica = instanceNames.size() - 1;
            masterStateValue = slaveStateValue = state;
        }
        if (masterStateValue == null && slaveStateValue == null) {
            throw new HelixException("Invalid or unsupported state model definition");
        }
        if (masterStateValue == null) {
            masterStateValue = slaveStateValue;
        }
        if (idealState.getRebalanceMode() != IdealState.RebalanceMode.FULL_AUTO && idealState.getRebalanceMode() != IdealState.RebalanceMode.USER_DEFINED) {
            ZNRecord newIdealState = DefaultIdealStateCalculator.calculateIdealState(instanceNames, partitions, replica, keyPrefix, masterStateValue, slaveStateValue);
            if (idealState.getRebalanceMode() == IdealState.RebalanceMode.SEMI_AUTO) {
                idealState.getRecord().setListFields(newIdealState.getListFields());
                idealState.getRecord().setMapFields(newIdealState.getMapFields());
            }
            if (idealState.getRebalanceMode() == IdealState.RebalanceMode.CUSTOMIZED) {
                idealState.getRecord().setMapFields(newIdealState.getMapFields());
            }
        } else {
            for (int i = 0; i < partitions; ++i) {
                String partitionName = keyPrefix + "_" + i;
                idealState.getRecord().setMapField(partitionName, new HashMap<String, String>());
                idealState.getRecord().setListField(partitionName, new ArrayList<String>());
            }
        }
        this.setResourceIdealState(clusterName, resourceName, idealState);
    }

    @Override
    public void addIdealState(String clusterName, String resourceName, String idealStateFile) throws IOException {
        ZNRecord idealStateRecord = (ZNRecord)new ZNRecordSerializer().deserialize(ZKHelixAdmin.readFile(idealStateFile));
        if (idealStateRecord.getId() == null || !idealStateRecord.getId().equals(resourceName)) {
            throw new IllegalArgumentException("ideal state must have same id as resource name");
        }
        this.setResourceIdealState(clusterName, resourceName, new IdealState(idealStateRecord));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] readFile(String filePath) throws IOException {
        File file = new File(filePath);
        int size = (int)file.length();
        byte[] bytes = new byte[size];
        FilterInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(file));
            int numRead = 0;
            for (int read = 0; read < bytes.length && (numRead = ((DataInputStream)dis).read(bytes, read, bytes.length - read)) >= 0; read += numRead) {
            }
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            if (dis != null) {
                dis.close();
            }
        }
    }

    @Override
    public void addStateModelDef(String clusterName, String stateModelDefName, String stateModelDefFile) throws IOException {
        ZNRecord record = (ZNRecord)new ZNRecordSerializer().deserialize(ZKHelixAdmin.readFile(stateModelDefFile));
        if (record == null || record.getId() == null || !record.getId().equals(stateModelDefName)) {
            throw new IllegalArgumentException("state model definition must have same id as state model def name");
        }
        this.addStateModelDef(clusterName, stateModelDefName, new StateModelDefinition(record));
    }

    @Override
    public void setConstraint(String clusterName, final ClusterConstraints.ConstraintType constraintType, final String constraintId, final ConstraintItem constraintItem) {
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        String path = keyBuilder.constraint(constraintType.toString()).getPath();
        baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                ClusterConstraints constraints = currentData == null ? new ClusterConstraints(constraintType) : new ClusterConstraints(currentData);
                constraints.addConstraintItem(constraintId, constraintItem);
                return constraints.getRecord();
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public void removeConstraint(String clusterName, ClusterConstraints.ConstraintType constraintType, final String constraintId) {
        ZkBaseDataAccessor<ZNRecord> baseAccessor = new ZkBaseDataAccessor<ZNRecord>(this._zkClient);
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        String path = keyBuilder.constraint(constraintType.toString()).getPath();
        baseAccessor.update(path, new DataUpdater<ZNRecord>(){

            public ZNRecord update(ZNRecord currentData) {
                if (currentData != null) {
                    ClusterConstraints constraints = new ClusterConstraints(currentData);
                    constraints.removeConstraintItem(constraintId);
                    return constraints.getRecord();
                }
                return null;
            }
        }, AccessOption.PERSISTENT);
    }

    @Override
    public ClusterConstraints getConstraints(String clusterName, ClusterConstraints.ConstraintType constraintType) {
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = new PropertyKey.Builder(clusterName);
        return (ClusterConstraints)accessor.getProperty(keyBuilder.constraint(constraintType.toString()));
    }

    @Override
    public void rebalance(String clusterName, IdealState currentIdealState, List<String> instanceNames) {
        HashSet<String> activeInstances = new HashSet<String>();
        for (String partition : currentIdealState.getPartitionSet()) {
            activeInstances.addAll(currentIdealState.getRecord().getListField(partition));
        }
        instanceNames.removeAll(activeInstances);
        Map<String, Object> previousIdealState = RebalanceUtil.buildInternalIdealState(currentIdealState);
        Map<String, Object> balancedRecord = DefaultIdealStateCalculator.calculateNextIdealState(instanceNames, previousIdealState);
        StateModelDefinition stateModDef = this.getStateModelDef(clusterName, currentIdealState.getStateModelDefRef());
        if (stateModDef == null) {
            throw new HelixException("cannot find state model: " + currentIdealState.getStateModelDefRef());
        }
        String[] states = RebalanceUtil.parseStates(clusterName, stateModDef);
        ZNRecord newIdealStateRecord = DefaultIdealStateCalculator.convertToZNRecord(balancedRecord, currentIdealState.getResourceName(), states[0], states[1]);
        HashSet<String> partitionSet = new HashSet<String>();
        partitionSet.addAll(newIdealStateRecord.getMapFields().keySet());
        partitionSet.addAll(newIdealStateRecord.getListFields().keySet());
        Map reversePartitionIndex = (Map)balancedRecord.get("reversePartitionIndex");
        for (String partition : partitionSet) {
            String originPartitionName;
            if (!reversePartitionIndex.containsKey(partition) || partition.equals(originPartitionName = (String)reversePartitionIndex.get(partition))) continue;
            newIdealStateRecord.getMapFields().put(originPartitionName, newIdealStateRecord.getMapField(partition));
            newIdealStateRecord.getMapFields().remove(partition);
            newIdealStateRecord.getListFields().put(originPartitionName, newIdealStateRecord.getListField(partition));
            newIdealStateRecord.getListFields().remove(partition);
        }
        newIdealStateRecord.getSimpleFields().putAll(currentIdealState.getRecord().getSimpleFields());
        IdealState newIdealState = new IdealState(newIdealStateRecord);
        this.setResourceIdealState(clusterName, newIdealStateRecord.getId(), newIdealState);
    }

    @Override
    public void addInstanceTag(String clusterName, String instanceName, String tag) {
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        if (!ZKUtil.isInstanceSetup(this._zkClient, clusterName, instanceName, InstanceType.PARTICIPANT)) {
            throw new HelixException("cluster " + clusterName + " instance " + instanceName + " is not setup yet");
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        InstanceConfig config = (InstanceConfig)accessor.getProperty(keyBuilder.instanceConfig(instanceName));
        config.addTag(tag);
        accessor.setProperty(keyBuilder.instanceConfig(instanceName), config);
    }

    @Override
    public void removeInstanceTag(String clusterName, String instanceName, String tag) {
        if (!ZKUtil.isClusterSetup(clusterName, this._zkClient)) {
            throw new HelixException("cluster " + clusterName + " is not setup yet");
        }
        if (!ZKUtil.isInstanceSetup(this._zkClient, clusterName, instanceName, InstanceType.PARTICIPANT)) {
            throw new HelixException("cluster " + clusterName + " instance " + instanceName + " is not setup yet");
        }
        ZKHelixDataAccessor accessor = new ZKHelixDataAccessor(clusterName, new ZkBaseDataAccessor<ZNRecord>(this._zkClient));
        PropertyKey.Builder keyBuilder = accessor.keyBuilder();
        InstanceConfig config = (InstanceConfig)accessor.getProperty(keyBuilder.instanceConfig(instanceName));
        config.removeTag(tag);
        accessor.setProperty(keyBuilder.instanceConfig(instanceName), config);
    }

    @Override
    public void close() {
        if (this._zkClient != null) {
            this._zkClient.close();
        }
    }
}

