/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.helix.HelixProperty;
import org.apache.helix.ZNRecord;
import org.apache.helix.model.ConstraintItem;
import org.apache.helix.model.Message;
import org.apache.helix.model.builder.ConstraintItemBuilder;
import org.apache.log4j.Logger;

public class ClusterConstraints
extends HelixProperty {
    private static Logger LOG = Logger.getLogger(ClusterConstraints.class);
    private final Map<String, ConstraintItem> _constraints = new HashMap<String, ConstraintItem>();

    public ClusterConstraints(ConstraintType type) {
        super(type.toString());
    }

    public ClusterConstraints(ZNRecord record) {
        super(record);
        Iterator<String> i$ = this._record.getMapFields().keySet().iterator();
        while (i$.hasNext()) {
            ConstraintItemBuilder builder = new ConstraintItemBuilder();
            String constraintId = i$.next();
            ConstraintItem item = builder.addConstraintAttributes(this._record.getMapField(constraintId)).build();
            if (item.getAttributes().size() > 0 && item.getConstraintValue() != null) {
                this.addConstraintItem(constraintId, item);
                continue;
            }
            LOG.error((Object)("Skip invalid constraint. key: " + constraintId + ", value: " + this._record.getMapField(constraintId)));
        }
    }

    public void addConstraintItem(String constraintId, ConstraintItem item) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        for (ConstraintAttribute attr : item.getAttributes().keySet()) {
            map.put(attr.toString(), item.getAttributeValue(attr));
        }
        map.put(ConstraintAttribute.CONSTRAINT_VALUE.toString(), item.getConstraintValue());
        this._record.setMapField(constraintId, map);
        this._constraints.put(constraintId, item);
    }

    public void addConstraintItems(Map<String, ConstraintItem> items) {
        for (String constraintId : items.keySet()) {
            this.addConstraintItem(constraintId, items.get(constraintId));
        }
    }

    public void removeConstraintItem(String constraintId) {
        this._constraints.remove(constraintId);
        this._record.getMapFields().remove(constraintId);
    }

    public ConstraintItem getConstraintItem(String constraintId) {
        return this._constraints.get(constraintId);
    }

    public Set<ConstraintItem> match(Map<ConstraintAttribute, String> attributes) {
        HashSet<ConstraintItem> matches = new HashSet<ConstraintItem>();
        for (ConstraintItem item : this._constraints.values()) {
            if (!item.match(attributes)) continue;
            matches.add(item);
        }
        return matches;
    }

    public static Map<ConstraintAttribute, String> toConstraintAttributes(Message msg) {
        TreeMap<ConstraintAttribute, String> attributes = new TreeMap<ConstraintAttribute, String>();
        String msgType = msg.getMsgType();
        attributes.put(ConstraintAttribute.MESSAGE_TYPE, msgType);
        if (Message.MessageType.STATE_TRANSITION.toString().equals(msgType)) {
            if (msg.getFromState() != null && msg.getToState() != null) {
                attributes.put(ConstraintAttribute.TRANSITION, msg.getFromState() + "-" + msg.getToState());
            }
            if (msg.getResourceName() != null) {
                attributes.put(ConstraintAttribute.RESOURCE, msg.getResourceName());
            }
            if (msg.getTgtName() != null) {
                attributes.put(ConstraintAttribute.INSTANCE, msg.getTgtName());
            }
            if (msg.getPartitionName() != null) {
                attributes.put(ConstraintAttribute.PARTITION, msg.getPartitionName());
            }
        }
        return attributes;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public static enum ConstraintType {
        STATE_CONSTRAINT,
        MESSAGE_CONSTRAINT;

    }

    public static enum ConstraintValue {
        ANY;

    }

    public static enum ConstraintAttribute {
        STATE,
        MESSAGE_TYPE,
        TRANSITION,
        RESOURCE,
        PARTITION,
        INSTANCE,
        CONSTRAINT_VALUE;

    }
}

