/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.relocated.freemarker.core;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.uberfire.relocated.freemarker.core.Environment;
import org.uberfire.relocated.freemarker.core.Expression;
import org.uberfire.relocated.freemarker.core.StringLiteral;
import org.uberfire.relocated.freemarker.template.SimpleSequence;
import org.uberfire.relocated.freemarker.template.TemplateException;
import org.uberfire.relocated.freemarker.template.TemplateModel;
import org.uberfire.relocated.freemarker.template.TemplateSequenceModel;
import org.uberfire.relocated.freemarker.template.utility.Collections12;

final class ListLiteral
extends Expression {
    final ArrayList values;

    ListLiteral(ArrayList values) {
        this.values = values;
        values.trimToSize();
    }

    TemplateModel _getAsTemplateModel(Environment env) throws TemplateException {
        SimpleSequence list = new SimpleSequence(this.values.size());
        Iterator it = this.values.iterator();
        while (it.hasNext()) {
            Expression exp = (Expression)it.next();
            TemplateModel tm = exp.getAsTemplateModel(env);
            ListLiteral.assertNonNull(tm, exp, env);
            list.add(tm);
        }
        return list;
    }

    List getValueList(Environment env) throws TemplateException {
        int size = this.values.size();
        switch (size) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections12.singletonList(((Expression)this.values.get(0)).getStringValue(env));
            }
        }
        ArrayList<String> result = new ArrayList<String>(this.values.size());
        ListIterator iterator = this.values.listIterator();
        while (iterator.hasNext()) {
            Expression exp = (Expression)iterator.next();
            result.add(exp.getStringValue(env));
        }
        return result;
    }

    List getModelList(Environment env) throws TemplateException {
        int size = this.values.size();
        switch (size) {
            case 0: {
                return Collections.EMPTY_LIST;
            }
            case 1: {
                return Collections12.singletonList(((Expression)this.values.get(0)).getAsTemplateModel(env));
            }
        }
        ArrayList<TemplateModel> result = new ArrayList<TemplateModel>(this.values.size());
        ListIterator iterator = this.values.listIterator();
        while (iterator.hasNext()) {
            Expression exp = (Expression)iterator.next();
            result.add(exp.getAsTemplateModel(env));
        }
        return result;
    }

    public String getCanonicalForm() {
        StringBuffer buf = new StringBuffer("[");
        int size = this.values.size();
        for (int i = 0; i < size; ++i) {
            Expression value = (Expression)this.values.get(i);
            buf.append(value.getCanonicalForm());
            if (i == size - 1) continue;
            buf.append(",");
        }
        buf.append("]");
        return buf.toString();
    }

    boolean isLiteral() {
        if (this.constantValue != null) {
            return true;
        }
        for (int i = 0; i < this.values.size(); ++i) {
            Expression exp = (Expression)this.values.get(i);
            if (exp.isLiteral()) continue;
            return false;
        }
        return true;
    }

    TemplateSequenceModel evaluateStringsToNamespaces(Environment env) throws TemplateException {
        TemplateSequenceModel val = (TemplateSequenceModel)this.getAsTemplateModel(env);
        SimpleSequence result = new SimpleSequence(val.size());
        for (int i = 0; i < this.values.size(); ++i) {
            if (this.values.get(i) instanceof StringLiteral) {
                String s = ((StringLiteral)this.values.get(i)).getAsString();
                try {
                    Environment.Namespace ns = env.importLib(s, null);
                    result.add(ns);
                    continue;
                }
                catch (IOException ioe) {
                    throw new TemplateException("Could not import library '" + s + "', " + ioe.getMessage(), env);
                }
            }
            result.add(val.get(i));
        }
        return result;
    }

    Expression _deepClone(String name, Expression subst) {
        ArrayList clonedValues = (ArrayList)this.values.clone();
        ListIterator<Expression> iter = clonedValues.listIterator();
        while (iter.hasNext()) {
            iter.set(((Expression)iter.next()).deepClone(name, subst));
        }
        return new ListLiteral(clonedValues);
    }
}

