/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.access;

import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.apache.clerezza.rdf.core.Triple;

class LockingIterator
implements Iterator<Triple> {
    private Iterator<Triple> base;
    private Lock readLock;
    private Lock writeLock;

    public LockingIterator(Iterator<Triple> iterator, ReadWriteLock lock) {
        this.base = iterator;
        this.readLock = lock.readLock();
        this.writeLock = lock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasNext() {
        this.readLock.lock();
        try {
            boolean bl = this.base.hasNext();
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Triple next() {
        this.readLock.lock();
        try {
            Triple triple = this.base.next();
            return triple;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() {
        this.writeLock.lock();
        try {
            this.base.remove();
        }
        finally {
            this.writeLock.unlock();
        }
    }
}

