/*
 * Decompiled with CFR 0.152.
 */
package org.apache.clerezza.rdf.core.impl;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;
import org.apache.clerezza.rdf.core.event.GraphEvent;
import org.apache.clerezza.rdf.core.event.GraphListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DelayedNotificator {
    private static final Logger log = LoggerFactory.getLogger(DelayedNotificator.class);
    private static Timer timer = new Timer("Event delivery timer", true);
    private final Map<GraphListener, ListenerHolder> map = Collections.synchronizedMap(new WeakHashMap());

    DelayedNotificator() {
    }

    void addDelayedListener(GraphListener listener, long delay) {
        this.map.put(listener, new ListenerHolder(listener, delay));
    }

    void removeDelayedListener(GraphListener listener) {
        this.map.remove(listener);
    }

    void sendEventToListener(GraphListener listener, GraphEvent event) {
        ListenerHolder holder = this.map.get(listener);
        if (holder == null) {
            listener.graphChanged(Collections.singletonList(event));
        } else {
            holder.registerEvent(event);
        }
    }

    static class ListenerHolder {
        long delay;
        List<GraphEvent> events = null;
        WeakReference<GraphListener> listenerRef;

        public ListenerHolder(GraphListener listener, long delay) {
            this.listenerRef = new WeakReference<GraphListener>(listener);
            this.delay = delay;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void registerEvent(GraphEvent event) {
            ListenerHolder listenerHolder = this;
            synchronized (listenerHolder) {
                if (this.events == null) {
                    this.events = new ArrayList<GraphEvent>();
                    this.events.add(event);
                    timer.schedule(new TimerTask(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            List<GraphEvent> eventsLocal;
                            ListenerHolder listenerHolder = ListenerHolder.this;
                            synchronized (listenerHolder) {
                                eventsLocal = ListenerHolder.this.events;
                                ListenerHolder.this.events = null;
                            }
                            GraphListener listener = (GraphListener)ListenerHolder.this.listenerRef.get();
                            if (listener == null) {
                                log.debug("Ignoring garbage collected listener");
                            } else {
                                try {
                                    listener.graphChanged(eventsLocal);
                                }
                                catch (Exception e) {
                                    log.warn("Exception delivering graph event", (Throwable)e);
                                }
                            }
                        }
                    }, this.delay);
                } else {
                    this.events.add(event);
                }
            }
        }
    }
}

