/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.core.Dispatcher;
import org.jboss.resteasy.core.SynchronousDispatcher;
import org.jboss.resteasy.core.ThreadLocalResteasyProviderFactory;
import org.jboss.resteasy.plugins.server.servlet.ConfigurationBootstrap;
import org.jboss.resteasy.plugins.server.servlet.HttpRequestFactory;
import org.jboss.resteasy.plugins.server.servlet.HttpResponseFactory;
import org.jboss.resteasy.plugins.server.servlet.ServletSecurityContext;
import org.jboss.resteasy.plugins.server.servlet.ServletUtil;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.specimpl.UriInfoImpl;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.NotFoundException;
import org.jboss.resteasy.spi.Registry;
import org.jboss.resteasy.spi.ResteasyDeployment;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.util.GetRestful;

public class ServletContainerDispatcher {
    protected Dispatcher dispatcher;
    protected ResteasyProviderFactory providerFactory;
    private String servletMappingPrefix = "";
    protected ResteasyDeployment deployment = null;
    protected HttpRequestFactory requestFactory;
    protected HttpResponseFactory responseFactory;

    public Dispatcher getDispatcher() {
        return this.dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletContext servletContext, ConfigurationBootstrap bootstrap, HttpRequestFactory requestFactory, HttpResponseFactory responseFactory) throws ServletException {
        this.requestFactory = requestFactory;
        this.responseFactory = responseFactory;
        this.providerFactory = (ResteasyProviderFactory)((Object)servletContext.getAttribute(ResteasyProviderFactory.class.getName()));
        this.dispatcher = (Dispatcher)servletContext.getAttribute(Dispatcher.class.getName());
        if (this.providerFactory != null && this.dispatcher == null || this.providerFactory == null && this.dispatcher != null) {
            throw new ServletException(Messages.MESSAGES.unknownStateListener());
        }
        if (this.providerFactory == null) {
            this.deployment = bootstrap.createDeployment();
            this.deployment.start();
            servletContext.setAttribute(ResteasyProviderFactory.class.getName(), (Object)this.deployment.getProviderFactory());
            servletContext.setAttribute(Dispatcher.class.getName(), (Object)this.deployment.getDispatcher());
            servletContext.setAttribute(Registry.class.getName(), (Object)this.deployment.getRegistry());
            this.dispatcher = this.deployment.getDispatcher();
            this.providerFactory = this.deployment.getProviderFactory();
        } else {
            String application = bootstrap.getInitParameter("javax.ws.rs.Application");
            if (application != null) {
                try {
                    Application app = ResteasyDeployment.createApplication(application.trim(), this.providerFactory);
                    this.dispatcher.getDefaultContextObjects().put(Application.class, app);
                    Map<Class<?>, Object> contextDataMap = ResteasyProviderFactory.getContextDataMap();
                    contextDataMap.putAll(this.dispatcher.getDefaultContextObjects());
                    this.processApplication(app);
                }
                finally {
                    ResteasyProviderFactory.removeContextDataLevel();
                }
            }
        }
        this.servletMappingPrefix = bootstrap.getParameter("resteasy.servlet.mapping.prefix");
        if (this.servletMappingPrefix == null) {
            this.servletMappingPrefix = "";
        }
        this.servletMappingPrefix = this.servletMappingPrefix.trim();
    }

    public void destroy() {
        if (this.deployment != null) {
            this.deployment.stop();
        }
    }

    protected void processApplication(Application config) {
        LogMessages.LOGGER.deployingApplication(Application.class.getName(), config.getClass());
        ArrayList<Class> actualResourceClasses = new ArrayList<Class>();
        ArrayList<Class> actualProviderClasses = new ArrayList<Class>();
        ArrayList resources = new ArrayList();
        ArrayList providers = new ArrayList();
        if (config.getClasses() != null) {
            for (Class clazz : config.getClasses()) {
                if (GetRestful.isRootResource(clazz)) {
                    actualResourceClasses.add(clazz);
                    continue;
                }
                if (clazz.isAnnotationPresent(Provider.class)) {
                    actualProviderClasses.add(clazz);
                    continue;
                }
                throw new RuntimeException(Messages.MESSAGES.unknownClassTypeGetClasses(clazz.getName()));
            }
        }
        if (config.getSingletons() != null) {
            for (Object obj : config.getSingletons()) {
                if (GetRestful.isRootResource(obj.getClass())) {
                    LogMessages.LOGGER.addingSingletonResource(obj.getClass().getName(), Application.class.getName());
                    resources.add(obj);
                    continue;
                }
                if (obj.getClass().isAnnotationPresent(Provider.class)) {
                    LogMessages.LOGGER.addingSingletonProvider(obj.getClass().getName(), Application.class.getName());
                    providers.add(obj);
                    continue;
                }
                throw new RuntimeException(Messages.MESSAGES.unknownClassTypeGetSingletons(obj.getClass().getName()));
            }
        }
        for (Class clazz : actualProviderClasses) {
            this.providerFactory.registerProvider(clazz);
        }
        for (Object obj : providers) {
            this.providerFactory.registerProviderInstance(obj);
        }
        for (Class clazz : actualResourceClasses) {
            this.dispatcher.getRegistry().addPerRequestResource(clazz);
        }
        for (Object obj : resources) {
            this.dispatcher.getRegistry().addSingletonResource(obj);
        }
    }

    public void setDispatcher(Dispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(String httpMethod, HttpServletRequest request, HttpServletResponse response, boolean handleNotFound) throws IOException, NotFoundException {
        try {
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.push(this.providerFactory);
            }
            HttpHeaders headers = null;
            UriInfoImpl uriInfo = null;
            try {
                headers = ServletUtil.extractHttpHeaders(request);
                uriInfo = ServletUtil.extractUriInfo(request, this.servletMappingPrefix);
            }
            catch (Exception e) {
                response.sendError(400);
                LogMessages.LOGGER.failedToParseRequest(e);
                ResteasyProviderFactory defaultInstance2 = ResteasyProviderFactory.getInstance();
                if (defaultInstance2 instanceof ThreadLocalResteasyProviderFactory) {
                    ThreadLocalResteasyProviderFactory.pop();
                }
                return;
            }
            HttpResponse theResponse = this.responseFactory.createResteasyHttpResponse(response);
            HttpRequest in = this.requestFactory.createResteasyHttpRequest(httpMethod, request, headers, uriInfo, theResponse, response);
            try {
                ResteasyProviderFactory.pushContext(HttpServletRequest.class, request);
                ResteasyProviderFactory.pushContext(HttpServletResponse.class, response);
                ResteasyProviderFactory.pushContext(SecurityContext.class, new ServletSecurityContext(request));
                if (handleNotFound) {
                    this.dispatcher.invoke(in, theResponse);
                } else {
                    ((SynchronousDispatcher)this.dispatcher).invokePropagateNotFound(in, theResponse);
                }
            }
            finally {
                ResteasyProviderFactory.clearContextData();
            }
        }
        finally {
            ResteasyProviderFactory defaultInstance = ResteasyProviderFactory.getInstance();
            if (defaultInstance instanceof ThreadLocalResteasyProviderFactory) {
                ThreadLocalResteasyProviderFactory.pop();
            }
        }
    }
}

