/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.backend.server.cdi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessProducer;
import javax.enterprise.inject.spi.WithAnnotations;
import javax.enterprise.util.AnnotationLiteral;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.uberfire.commons.cluster.ClusterServiceFactory;
import org.uberfire.commons.lifecycle.PriorityDisposableRegistry;
import org.uberfire.commons.services.cdi.Startable;
import org.uberfire.commons.services.cdi.Startup;
import org.uberfire.commons.services.cdi.StartupType;
import org.uberfire.commons.services.cdi.Veto;
import org.uberfire.io.IOService;
import org.uberfire.io.impl.IOServiceNio2WrapperImpl;
import org.uberfire.io.impl.cluster.IOServiceClusterImpl;
import org.uberfire.java.nio.IOException;
import org.uberfire.java.nio.base.FileSystemState;
import org.uberfire.java.nio.file.FileStore;
import org.uberfire.java.nio.file.FileSystem;
import org.uberfire.java.nio.file.FileSystemAlreadyExistsException;
import org.uberfire.java.nio.file.InvalidPathException;
import org.uberfire.java.nio.file.Path;
import org.uberfire.java.nio.file.PathMatcher;
import org.uberfire.java.nio.file.PatternSyntaxException;
import org.uberfire.java.nio.file.WatchService;
import org.uberfire.java.nio.file.attribute.UserPrincipalLookupService;
import org.uberfire.java.nio.file.spi.FileSystemProvider;

public class SystemConfigProducer
implements Extension {
    private static final Logger logger = LoggerFactory.getLogger(SystemConfigProducer.class);
    private static final String CDI_METHOD = "cdi";
    private static final String START_METHOD = System.getProperty("org.uberfire.start.method", "cdi");
    private final List<OrderedBean> startupEagerBeans = new LinkedList<OrderedBean>();
    private final List<OrderedBean> startupBootstrapBeans = new LinkedList<OrderedBean>();
    private boolean systemFSNotExists = true;
    private boolean ioStrategyBeanNotFound = true;
    private final Comparator<OrderedBean> priorityComparator = new Comparator<OrderedBean>(){

        @Override
        public int compare(OrderedBean o1, OrderedBean o2) {
            return o1.priority - o2.priority;
        }
    };

    public void processSystemFSProducer(@Observes ProcessProducer<?, FileSystem> pp) {
        if (pp.getAnnotatedMember().getJavaMember().getName().equals("systemFS")) {
            this.ioStrategyBeanNotFound = false;
        }
    }

    public void processIOServiceProducer(@Observes ProcessProducer<?, IOService> pp) {
        if (pp.getAnnotatedMember().getJavaMember().getName().equals("ioStrategy")) {
            this.ioStrategyBeanNotFound = false;
        }
    }

    public <X> void processBean(@Observes ProcessBean<X> event) {
        Named namedAnnotation;
        if (event.getBean().getName() != null && event.getBean().getName().equals("systemFS")) {
            this.systemFSNotExists = false;
        } else if (event.getBean().getName() != null && event.getBean().getName().equals("ioStrategy")) {
            this.ioStrategyBeanNotFound = false;
        }
        if (event.getAnnotated().isAnnotationPresent(Startup.class) && (event.getAnnotated().isAnnotationPresent(ApplicationScoped.class) || event.getAnnotated().isAnnotationPresent(Singleton.class))) {
            Startup startupAnnotation = (Startup)event.getAnnotated().getAnnotation(Startup.class);
            StartupType type = startupAnnotation.value();
            int priority = startupAnnotation.priority();
            Bean bean = event.getBean();
            switch (type) {
                case EAGER: {
                    this.startupEagerBeans.add(new OrderedBean(bean, priority));
                    break;
                }
                case BOOTSTRAP: {
                    this.startupBootstrapBeans.add(new OrderedBean(bean, priority));
                }
            }
        } else if (event.getAnnotated().isAnnotationPresent(Named.class) && (event.getAnnotated().isAnnotationPresent(ApplicationScoped.class) || event.getAnnotated().isAnnotationPresent(Singleton.class)) && (namedAnnotation = (Named)event.getAnnotated().getAnnotation(Named.class)).value().endsWith("-startable")) {
            Bean bean = event.getBean();
            this.startupBootstrapBeans.add(new OrderedBean(bean, 10));
        }
    }

    public void afterDeploymentValidation(@Observes AfterDeploymentValidation event, BeanManager manager) {
        if (CDI_METHOD.equalsIgnoreCase(START_METHOD)) {
            this.runPostConstruct(manager, this.startupBootstrapBeans);
            this.runPostConstruct(manager, this.startupEagerBeans);
        }
    }

    private void runPostConstruct(BeanManager manager, List<OrderedBean> orderedBeans) {
        Collections.sort(orderedBeans, this.priorityComparator);
        for (OrderedBean ob : orderedBeans) {
            Bean<?> bean = ob.bean;
            manager.getReference(bean, (Type)bean.getBeanClass(), manager.createCreationalContext(bean)).toString();
        }
    }

    <T> void processAnnotatedType(@Observes @WithAnnotations(value={Veto.class}) ProcessAnnotatedType<T> pat) {
        pat.veto();
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery abd, BeanManager bm) {
        if (this.systemFSNotExists) {
            this.buildSystemFS(abd, bm);
        }
        if (this.ioStrategyBeanNotFound) {
            this.buildIOStrategy(abd, bm);
        }
        if (!CDI_METHOD.equalsIgnoreCase(START_METHOD)) {
            this.buildStartableBean(abd, bm);
        }
    }

    private void buildSystemFS(AfterBeanDiscovery abd, BeanManager bm) {
        InjectionTarget it = bm.createInjectionTarget(bm.createAnnotatedType(DummyFileSystem.class));
        abd.addBean(this.createFileSystemBean(bm, (InjectionTarget<DummyFileSystem>)it));
    }

    Bean<FileSystem> createFileSystemBean(final BeanManager bm, final InjectionTarget<DummyFileSystem> it) {
        return new Bean<FileSystem>(){

            public Class<?> getBeanClass() {
                return FileSystem.class;
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return it.getInjectionPoints();
            }

            public String getName() {
                return "systemFS";
            }

            public Set<Annotation> getQualifiers() {
                return new HashSet<Annotation>(){
                    {
                        this.add(new AnnotationLiteral<Default>(){});
                        this.add(new AnnotationLiteral<Any>(){});
                        this.add(new NamedLiteral("systemFS"));
                    }
                };
            }

            public Class<? extends Annotation> getScope() {
                return ApplicationScoped.class;
            }

            public Set<Class<? extends Annotation>> getStereotypes() {
                return Collections.emptySet();
            }

            public Set<Type> getTypes() {
                return new HashSet<Type>(){
                    {
                        this.add(FileSystem.class);
                        this.add(Object.class);
                    }
                };
            }

            public boolean isAlternative() {
                return false;
            }

            public boolean isNullable() {
                return false;
            }

            public FileSystem create(CreationalContext<FileSystem> ctx) {
                FileSystem systemFS;
                Bean bean = (Bean)bm.getBeans("configIO").iterator().next();
                CreationalContext _ctx = bm.createCreationalContext((Contextual)bean);
                IOService ioService = (IOService)bm.getReference(bean, IOService.class, _ctx);
                try {
                    systemFS = ioService.newFileSystem(URI.create("git://system"), (Map)new HashMap<String, Object>(){
                        {
                            this.put("init", Boolean.TRUE);
                            this.put("internal", Boolean.TRUE);
                        }
                    });
                }
                catch (FileSystemAlreadyExistsException e) {
                    systemFS = ioService.getFileSystem(URI.create("git://system"));
                }
                PriorityDisposableRegistry.register((String)"systemFS", (Object)systemFS);
                return systemFS;
            }

            public void destroy(FileSystem instance, CreationalContext<FileSystem> ctx) {
                try {
                    instance.dispose();
                    PriorityDisposableRegistry.unregister((String)"systemFS");
                }
                catch (Exception ex) {
                    logger.warn(ex.getMessage(), (Throwable)ex);
                }
                ctx.release();
            }
        };
    }

    private void buildIOStrategy(AfterBeanDiscovery abd, final BeanManager bm) {
        final InjectionTarget it = bm.createInjectionTarget(bm.createAnnotatedType(IOServiceNio2WrapperImpl.class));
        abd.addBean((Bean)new Bean<IOService>(){

            public Class<?> getBeanClass() {
                return IOService.class;
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return it.getInjectionPoints();
            }

            public String getName() {
                return "ioStrategy";
            }

            public Set<Annotation> getQualifiers() {
                return new HashSet<Annotation>(){
                    {
                        this.add(new AnnotationLiteral<Default>(){});
                        this.add(new AnnotationLiteral<Any>(){});
                        this.add(new NamedLiteral("ioStrategy"));
                    }
                };
            }

            public Class<? extends Annotation> getScope() {
                return ApplicationScoped.class;
            }

            public Set<Class<? extends Annotation>> getStereotypes() {
                return Collections.emptySet();
            }

            public Set<Type> getTypes() {
                return new HashSet<Type>(){
                    {
                        this.add(IOService.class);
                        this.add(Object.class);
                    }
                };
            }

            public boolean isAlternative() {
                return false;
            }

            public boolean isNullable() {
                return false;
            }

            public IOService create(CreationalContext<IOService> ctx) {
                CreationalContext _ctx;
                Bean clusterFactoryBean = (Bean)bm.getBeans("clusterServiceFactory").iterator().next();
                ClusterServiceFactory clusterServiceFactory = (ClusterServiceFactory)bm.getReference(clusterFactoryBean, ClusterServiceFactory.class, _ctx = bm.createCreationalContext((Contextual)clusterFactoryBean));
                Object result = clusterServiceFactory == null ? new IOServiceNio2WrapperImpl() : new IOServiceClusterImpl((IOService)new IOServiceNio2WrapperImpl(), clusterServiceFactory);
                return result;
            }

            public void destroy(IOService instance, CreationalContext<IOService> ctx) {
                ctx.release();
            }
        });
    }

    private void buildStartableBean(AfterBeanDiscovery abd, final BeanManager bm) {
        abd.addBean((Bean)new Bean<Startable>(){

            public Class<?> getBeanClass() {
                return Startable.class;
            }

            public Set<InjectionPoint> getInjectionPoints() {
                return Collections.emptySet();
            }

            public String getName() {
                return "startablebean";
            }

            public Set<Annotation> getQualifiers() {
                return new HashSet<Annotation>(){
                    {
                        this.add(new AnnotationLiteral<Default>(){});
                        this.add(new AnnotationLiteral<Any>(){});
                    }
                };
            }

            public Class<? extends Annotation> getScope() {
                return ApplicationScoped.class;
            }

            public Set<Class<? extends Annotation>> getStereotypes() {
                return Collections.emptySet();
            }

            public Set<Type> getTypes() {
                return new HashSet<Type>(){
                    {
                        this.add(Startable.class);
                        this.add(Object.class);
                    }
                };
            }

            public boolean isAlternative() {
                return false;
            }

            public boolean isNullable() {
                return false;
            }

            public Startable create(CreationalContext<Startable> ctx) {
                return new Startable(){

                    public int hashCode() {
                        return super.hashCode();
                    }

                    public void start() {
                        SystemConfigProducer.this.runPostConstruct(bm, SystemConfigProducer.this.startupBootstrapBeans);
                        SystemConfigProducer.this.runPostConstruct(bm, SystemConfigProducer.this.startupEagerBeans);
                    }
                };
            }

            public void destroy(Startable instance, CreationalContext<Startable> ctx) {
                ctx.release();
            }
        });
    }

    public class NamedLiteral
    extends AnnotationLiteral<Named>
    implements Named {
        private final String value;

        public String value() {
            return this.value;
        }

        public NamedLiteral(String value) {
            this.value = value;
        }
    }

    private class DummyStarable
    implements Startable {
        private DummyStarable() {
        }

        public void start() {
        }
    }

    public static class DummyFileSystem
    implements FileSystem {
        private FileSystemState state = FileSystemState.NORMAL;

        public FileSystemProvider provider() {
            return null;
        }

        public boolean isOpen() {
            return false;
        }

        public boolean isReadOnly() {
            return false;
        }

        public String getSeparator() {
            return null;
        }

        public Iterable<Path> getRootDirectories() {
            return null;
        }

        public Iterable<FileStore> getFileStores() {
            return null;
        }

        public Set<String> supportedFileAttributeViews() {
            return null;
        }

        public Path getPath(String first, String ... more) throws InvalidPathException {
            return null;
        }

        public PathMatcher getPathMatcher(String syntaxAndPattern) throws IllegalArgumentException, PatternSyntaxException, UnsupportedOperationException {
            return null;
        }

        public UserPrincipalLookupService getUserPrincipalLookupService() throws UnsupportedOperationException {
            return null;
        }

        public WatchService newWatchService() throws UnsupportedOperationException, IOException {
            return null;
        }

        public void close() throws IOException {
        }

        public void dispose() {
        }
    }

    private class OrderedBean {
        Bean<?> bean;
        int priority;

        private OrderedBean(Bean<?> bean, int priority) {
            this.bean = bean;
            this.priority = priority;
        }
    }
}

