/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.RootLayoutPanel;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.errai.bus.client.api.ClientMessageBus;
import org.jboss.errai.bus.client.framework.ClientMessageBusImpl;
import org.jboss.errai.ioc.client.api.AfterInitialization;
import org.jboss.errai.ioc.client.api.EntryPoint;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.jboss.errai.security.shared.api.identity.User;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PerspectiveActivity;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.resources.WorkbenchResources;
import org.uberfire.client.workbench.LayoutSelection;
import org.uberfire.client.workbench.VFSServiceProxy;
import org.uberfire.client.workbench.WorkbenchCloseHandler;
import org.uberfire.client.workbench.WorkbenchLayout;
import org.uberfire.client.workbench.events.ApplicationReadyEvent;
import org.uberfire.mvp.ParameterizedCommand;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.DefaultPlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;
import org.uberfire.rpc.SessionInfo;
import org.uberfire.rpc.impl.SessionInfoImpl;
import org.uberfire.security.authz.AuthorizationManager;
import org.uberfire.security.authz.AuthorizationPolicy;
import org.uberfire.security.authz.PermissionManager;

@EntryPoint
public class Workbench {
    private final Set<Class<?>> startupBlockers = new HashSet();
    @Inject
    private Event<ApplicationReadyEvent> appReady;
    private boolean isStandaloneMode = false;
    private final Set<String> headersToKeep = new HashSet<String>();
    @Inject
    private SyncBeanManager iocManager;
    @Inject
    private PlaceManager placeManager;
    @Inject
    private PermissionManager permissionManager;
    @Inject
    private AuthorizationManager authorizationManager;
    @Inject
    private VFSServiceProxy vfsService;
    @Inject
    LayoutSelection layoutSelection;
    private WorkbenchLayout layout;
    @Inject
    private User identity;
    @Inject
    private ClientMessageBus bus;
    private SessionInfo sessionInfo = null;
    private final WorkbenchCloseHandler workbenchCloseHandler = (WorkbenchCloseHandler)GWT.create(WorkbenchCloseHandler.class);
    private final Command workbenchCloseCommand = new Command(){

        public void execute() {
            Workbench.this.placeManager.closeAllPlaces();
        }
    };

    public void addStartupBlocker(Class<?> responsibleParty) {
        this.startupBlockers.add(responsibleParty);
        System.out.println(responsibleParty.getName() + " is blocking workbench startup.");
    }

    public void removeStartupBlocker(Class<?> responsibleParty) {
        if (this.startupBlockers.remove(responsibleParty)) {
            System.out.println(responsibleParty.getName() + " is no longer blocking startup.");
        } else {
            System.out.println(responsibleParty.getName() + " tried to unblock startup, but it wasn't blocking to begin with!");
        }
        this.startIfNotBlocked();
    }

    @AfterInitialization
    void startIfNotBlocked() {
        System.out.println(this.startupBlockers.size() + " workbench startup blockers remain.");
        if (this.startupBlockers.isEmpty()) {
            this.bootstrap();
        }
    }

    @PostConstruct
    private void earlyInit() {
        this.layout = this.layoutSelection.get();
        WorkbenchResources.INSTANCE.CSS().ensureInjected();
        this.isStandaloneMode = Window.Location.getParameterMap().containsKey("standalone");
        for (Map.Entry parameter : Window.Location.getParameterMap().entrySet()) {
            if (!((String)parameter.getKey()).equals("header")) continue;
            this.headersToKeep.addAll((Collection)parameter.getValue());
        }
    }

    private void bootstrap() {
        System.out.println("Workbench starting...");
        ((SessionInfoImpl)this.currentSession()).setId(((ClientMessageBusImpl)this.bus).getSessionId());
        this.layout.setMarginWidgets(this.isStandaloneMode, this.headersToKeep);
        this.layout.onBootstrap();
        this.addLayoutToRootPanel(this.layout);
        if (!this.isStandaloneMode) {
            PerspectiveActivity homePerspective = this.getHomePerspectiveActivity();
            if (homePerspective != null) {
                this.appReady.fire((Object)new ApplicationReadyEvent());
                this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest(homePerspective.getIdentifier()));
            } else {
                Window.alert((String)"No home perspective available!");
            }
        } else {
            this.handleStandaloneMode(Window.Location.getParameterMap());
        }
        Window.addWindowClosingHandler((Window.ClosingHandler)new Window.ClosingHandler(){

            public void onWindowClosing(Window.ClosingEvent event) {
                Workbench.this.workbenchCloseHandler.onWindowClose(Workbench.this.workbenchCloseCommand);
            }
        });
        Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

            public void onResize(ResizeEvent event) {
                Workbench.this.layout.resizeTo(event.getWidth(), event.getHeight());
            }
        });
        Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

            public void execute() {
                Workbench.this.layout.onResize();
            }
        });
    }

    private void handleStandaloneMode(final Map<String, List<String>> parameters) {
        if (parameters.containsKey("perspective") && !parameters.get("perspective").isEmpty()) {
            this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest(parameters.get("perspective").get(0)));
        } else if (parameters.containsKey("path") && !parameters.get("path").isEmpty()) {
            this.placeManager.goTo((PlaceRequest)new DefaultPlaceRequest("StandaloneEditorPerspective"));
            this.vfsService.get(parameters.get("path").get(0), new ParameterizedCommand<Path>(){

                public void execute(Path response) {
                    if (parameters.containsKey("editor") && !((List)parameters.get("editor")).isEmpty()) {
                        Workbench.this.placeManager.goTo((PlaceRequest)new PathPlaceRequest(response, (String)((List)parameters.get("editor")).get(0)));
                    } else {
                        Workbench.this.placeManager.goTo((PlaceRequest)new PathPlaceRequest(response));
                    }
                }
            });
        }
    }

    public PerspectiveActivity getHomePerspectiveActivity() {
        PerspectiveActivity targetPerspective;
        PerspectiveActivity homePerspective = null;
        AuthorizationPolicy authPolicy = this.permissionManager.getAuthorizationPolicy();
        String homePerspectiveId = authPolicy.getHomePerspective(this.identity);
        PerspectiveActivity defaultPerspective = null;
        Collection perspectives = this.iocManager.lookupBeans(PerspectiveActivity.class);
        for (SyncBeanDef perspective : perspectives) {
            PerspectiveActivity instance = (PerspectiveActivity)perspective.getInstance();
            if (homePerspectiveId != null && homePerspectiveId.equals(instance.getIdentifier())) {
                homePerspective = instance;
                if (defaultPerspective == null) continue;
                this.iocManager.destroyBean((Object)defaultPerspective);
                continue;
            }
            if (instance.isDefault()) {
                defaultPerspective = instance;
                continue;
            }
            this.iocManager.destroyBean((Object)instance);
        }
        PerspectiveActivity perspectiveActivity = targetPerspective = homePerspective != null ? homePerspective : defaultPerspective;
        if (targetPerspective != null && this.authorizationManager.authorize(targetPerspective, this.identity)) {
            return targetPerspective;
        }
        return null;
    }

    @Produces
    @ApplicationScoped
    private SessionInfo currentSession() {
        if (this.sessionInfo == null) {
            this.sessionInfo = new SessionInfoImpl(this.identity);
        }
        return this.sessionInfo;
    }

    void addLayoutToRootPanel(WorkbenchLayout layout) {
        RootLayoutPanel.get().add(layout.getRoot());
    }
}

