/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.workbench;

import com.google.gwt.animation.client.Animation;
import com.google.gwt.core.client.Scheduler;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Timer;
import com.google.gwt.user.client.Window;
import com.google.gwt.user.client.ui.AbsolutePanel;
import com.google.gwt.user.client.ui.DockLayoutPanel;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.HasWidgets;
import com.google.gwt.user.client.ui.HeaderPanel;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Panel;
import com.google.gwt.user.client.ui.RequiresResize;
import com.google.gwt.user.client.ui.SimpleLayoutPanel;
import com.google.gwt.user.client.ui.Widget;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.uberfire.client.util.Layouts;
import org.uberfire.client.workbench.Footer;
import org.uberfire.client.workbench.Header;
import org.uberfire.client.workbench.OrderableIsWidget;
import org.uberfire.client.workbench.WorkbenchLayout;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchDragAndDropManager;
import org.uberfire.client.workbench.widgets.dnd.WorkbenchPickupDragController;
import org.uberfire.mvp.Command;

@ApplicationScoped
public class WorkbenchLayoutImpl
implements WorkbenchLayout {
    public static final String UF_MAXIMIZED_PANEL = "uf-maximized-panel";
    private static final int MAXIMIZED_PANEL_Z_INDEX = 100;
    @Inject
    private SyncBeanManager iocManager;
    @Inject
    private HeaderPanel root;
    private final DockLayoutPanel rootContainer = new DockLayoutPanel(Style.Unit.PX);
    private final SimpleLayoutPanel perspectiveRootContainer = new SimpleLayoutPanel();
    private final Panel headerPanel = new FlowPanel();
    private final Panel footerPanel = new FlowPanel();
    @Inject
    private WorkbenchDragAndDropManager dndManager;
    @Inject
    private WorkbenchPickupDragController dragController;
    private final Map<Widget, OriginalStyleInfo> maximizedWidgetOriginalStyles = new HashMap<Widget, OriginalStyleInfo>();

    @PostConstruct
    private void init() {
        this.perspectiveRootContainer.ensureDebugId("perspectiveRootContainer");
        this.headerPanel.ensureDebugId("workbenchHeaderPanel");
        this.footerPanel.ensureDebugId("workbenchFooterPanel");
        this.dragController.getBoundaryPanel().ensureDebugId("workbenchDragBoundary");
        this.root.addStyleName("uf-workbench-layout");
    }

    public HeaderPanel getRoot() {
        return this.root;
    }

    @Override
    public HasWidgets getPerspectiveContainer() {
        return this.perspectiveRootContainer;
    }

    private void setHeaderContents(List<Header> headers) {
        this.headerPanel.clear();
        this.root.remove((Widget)this.headerPanel);
        if (!headers.isEmpty()) {
            for (Header h : headers) {
                this.headerPanel.add((IsWidget)h);
            }
            this.root.setHeaderWidget((Widget)this.headerPanel);
        }
    }

    private void setFooterContents(List<Footer> footers) {
        this.footerPanel.clear();
        this.root.remove((Widget)this.footerPanel);
        if (!footers.isEmpty()) {
            for (Footer f : footers) {
                this.footerPanel.add((IsWidget)f);
            }
            this.root.setFooterWidget((Widget)this.footerPanel);
        }
    }

    @Override
    public void onBootstrap() {
        this.dndManager.unregisterDropControllers();
        AbsolutePanel dragBoundary = this.dragController.getBoundaryPanel();
        dragBoundary.add((Widget)this.perspectiveRootContainer);
        this.setupDocks();
        this.rootContainer.add((Widget)dragBoundary);
        Layouts.setToFillParent((Widget)this.perspectiveRootContainer);
        Layouts.setToFillParent((Widget)dragBoundary);
        Layouts.setToFillParent((Widget)this.rootContainer);
        this.root.setContentWidget((Widget)this.rootContainer);
    }

    private void setupDocks() {
        try {
            SyncBeanDef uberfireDocksIOCBeanDef = this.iocManager.lookupBean(UberfireDocks.class, new Annotation[0]);
            UberfireDocks instance = (UberfireDocks)uberfireDocksIOCBeanDef.getInstance();
            Command resizeCommand = new Command(){

                public void execute() {
                    Scheduler.get().scheduleDeferred(new Scheduler.ScheduledCommand(){

                        public void execute() {
                            WorkbenchLayoutImpl.this.onResize();
                        }
                    });
                }
            };
            if (instance != null) {
                instance.setup(this.rootContainer, resizeCommand);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void onResize() {
        this.resizeTo(Window.getClientWidth(), Window.getClientHeight());
    }

    @Override
    public void resizeTo(int width, int height) {
        this.root.setPixelSize(width, height);
        this.perspectiveRootContainer.onResize();
        new Timer(){

            public void run() {
                WorkbenchLayoutImpl.this.updateMaximizedPanelSizes();
            }
        }.schedule(5);
    }

    private void updateMaximizedPanelSizes() {
        for (Widget w : this.maximizedWidgetOriginalStyles.keySet()) {
            Style style = w.getElement().getStyle();
            style.setTop((double)this.perspectiveRootContainer.getAbsoluteTop(), Style.Unit.PX);
            style.setLeft((double)this.perspectiveRootContainer.getAbsoluteLeft(), Style.Unit.PX);
            style.setWidth((double)this.perspectiveRootContainer.getOffsetWidth(), Style.Unit.PX);
            style.setHeight((double)this.perspectiveRootContainer.getOffsetHeight(), Style.Unit.PX);
            if (!(w instanceof RequiresResize)) continue;
            ((RequiresResize)w).onResize();
        }
    }

    @Override
    public void maximize(Widget w) {
        if (this.maximizedWidgetOriginalStyles.get(w) != null) {
            return;
        }
        w.addStyleName(UF_MAXIMIZED_PANEL);
        new ExpandAnimation(w, this.maximizedWidgetOriginalStyles, this.perspectiveRootContainer).run();
    }

    @Override
    public void unmaximize(Widget w) {
        w.removeStyleName(UF_MAXIMIZED_PANEL);
        new CollapseAnimation(w, this.maximizedWidgetOriginalStyles).run();
    }

    @Override
    public void setMarginWidgets(boolean isStandaloneMode, Set<String> headersToKeep) {
        this.setHeaderContents(this.discoverMarginWidgets(isStandaloneMode, headersToKeep, Header.class));
        this.setFooterContents(this.discoverMarginWidgets(isStandaloneMode, headersToKeep, Footer.class));
    }

    private <T extends OrderableIsWidget> List<T> discoverMarginWidgets(boolean isStandaloneMode, Set<String> headersToKeep, Class<T> marginType) {
        Collection headerBeans = this.iocManager.lookupBeans(marginType);
        ArrayList<OrderableIsWidget> instances = new ArrayList<OrderableIsWidget>();
        for (SyncBeanDef headerBean : headerBeans) {
            if (!headerBean.isActivated()) continue;
            OrderableIsWidget instance = (OrderableIsWidget)headerBean.getInstance();
            if (isStandaloneMode && !headersToKeep.contains(instance.getId())) continue;
            instances.add(instance);
        }
        Collections.sort(instances, new Comparator<OrderableIsWidget>(){

            @Override
            public int compare(OrderableIsWidget o1, OrderableIsWidget o2) {
                if (o1.getOrder() < o2.getOrder()) {
                    return 1;
                }
                if (o1.getOrder() > o2.getOrder()) {
                    return -1;
                }
                return 0;
            }
        });
        return instances;
    }

    protected Widget getHeaderPanel() {
        return this.headerPanel;
    }

    protected static class CollapseAnimation
    extends AbstractResizeAnimation {
        private final OriginalStyleInfo originalStyleInfo;

        public CollapseAnimation(Widget w, Map<Widget, OriginalStyleInfo> maximizedWidgetOriginalStyles) {
            super(w, maximizedWidgetOriginalStyles);
            this.originalStyleInfo = maximizedWidgetOriginalStyles.remove(w);
        }

        @Override
        public int getTargetWidth() {
            return this.originalStyleInfo.getClientWidth();
        }

        @Override
        public int getTargetHeight() {
            return this.originalStyleInfo.getClientHeight();
        }

        @Override
        public int getTargetTop() {
            return this.originalStyleInfo.getAbsoluteTop();
        }

        @Override
        public int getTargetLeft() {
            return this.originalStyleInfo.getAbsoluteLeft();
        }

        protected void onComplete() {
            this.originalStyleInfo.restore(this.w);
            this.onResize();
        }
    }

    protected static class ExpandAnimation
    extends AbstractResizeAnimation {
        protected final SimpleLayoutPanel perspectiveRootContainer;

        public ExpandAnimation(Widget w, Map<Widget, OriginalStyleInfo> maximizedWidgetOriginalStyles, SimpleLayoutPanel perspectiveRootContainer) {
            super(w, maximizedWidgetOriginalStyles);
            this.perspectiveRootContainer = perspectiveRootContainer;
        }

        protected void onStart() {
            this.maximizedWidgetOriginalStyles.put(this.w, new OriginalStyleInfo(this.w));
            this.style.setZIndex(100);
            this.style.setHeight((double)this.w.getElement().getClientHeight(), Style.Unit.PX);
            this.style.setWidth((double)this.w.getElement().getClientWidth(), Style.Unit.PX);
            this.style.setTop((double)this.w.getAbsoluteTop(), Style.Unit.PX);
            this.style.setLeft((double)this.w.getAbsoluteLeft(), Style.Unit.PX);
            this.style.setPosition(Style.Position.FIXED);
        }

        @Override
        public int getTargetWidth() {
            return this.perspectiveRootContainer.getOffsetWidth();
        }

        @Override
        public int getTargetHeight() {
            return this.perspectiveRootContainer.getOffsetHeight();
        }

        @Override
        public int getTargetTop() {
            return this.perspectiveRootContainer.getAbsoluteTop();
        }

        @Override
        public int getTargetLeft() {
            return this.perspectiveRootContainer.getAbsoluteLeft();
        }

        protected void onComplete() {
            super.onComplete();
            this.onResize();
        }
    }

    protected static abstract class AbstractResizeAnimation
    extends Animation {
        protected final Style style;
        protected final Widget w;
        protected final Map<Widget, OriginalStyleInfo> maximizedWidgetOriginalStyles;

        public AbstractResizeAnimation(Widget w, Map<Widget, OriginalStyleInfo> maximizedWidgetOriginalStyles) {
            this.w = w;
            this.maximizedWidgetOriginalStyles = maximizedWidgetOriginalStyles;
            this.style = w.getElement().getStyle();
        }

        protected void onUpdate(double progress) {
            double width = this.newTarget(this.w.getElement().getClientWidth(), this.getTargetWidth(), progress);
            this.style.setWidth(width, Style.Unit.PX);
            double height = this.newTarget(this.w.getElement().getClientHeight(), this.getTargetHeight(), progress);
            this.style.setHeight(height, Style.Unit.PX);
            double top = this.newTarget(this.w.getAbsoluteTop(), this.getTargetTop(), progress);
            this.style.setTop(top, Style.Unit.PX);
            double left = this.newTarget(this.w.getAbsoluteLeft(), this.getTargetLeft(), progress);
            this.style.setLeft(left, Style.Unit.PX);
        }

        public abstract int getTargetWidth();

        public abstract int getTargetHeight();

        public abstract int getTargetTop();

        public abstract int getTargetLeft();

        public void run() {
            super.run(1000);
        }

        private double newTarget(int current, int target, double progress) {
            return Math.round((double)current + (double)(target - current) * progress);
        }

        public void onResize() {
            if (this.w instanceof RequiresResize) {
                ((RequiresResize)this.w).onResize();
            }
        }
    }

    protected static class OriginalStyleInfo {
        private String position;
        private String top;
        private String left;
        private String width;
        private String height;
        private String zIndex;
        private int absoluteTop;
        private int absoluteLeft;
        private int clientHeight;
        private int clientWidth;

        public OriginalStyleInfo(Widget w) {
            this.absoluteLeft = w.getAbsoluteLeft();
            this.absoluteTop = w.getAbsoluteTop();
            this.clientHeight = w.getElement().getClientHeight();
            this.clientWidth = w.getElement().getClientWidth();
            Style style = w.getElement().getStyle();
            this.position = style.getPosition();
            this.top = style.getTop();
            this.left = style.getLeft();
            this.width = style.getWidth();
            this.height = style.getHeight();
            this.zIndex = style.getZIndex();
        }

        public void restore(Widget w) {
            Style style = w.getElement().getStyle();
            style.setProperty("position", this.position);
            style.setProperty("top", this.top);
            style.setProperty("left", this.left);
            style.setProperty("width", this.width);
            style.setProperty("height", this.height);
            style.setProperty("zIndex", this.zIndex);
        }

        public int getAbsoluteTop() {
            return this.absoluteTop;
        }

        public int getAbsoluteLeft() {
            return this.absoluteLeft;
        }

        public int getClientHeight() {
            return this.clientHeight;
        }

        public int getClientWidth() {
            return this.clientWidth;
        }
    }
}

