/*
 * Decompiled with CFR 0.152.
 */
package org.uberfire.client.views.pfly.modal;

import com.google.gwt.core.client.GWT;
import com.google.gwt.safehtml.shared.SafeHtmlUtils;
import com.google.gwt.user.client.DOM;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import javax.enterprise.context.Dependent;
import org.gwtbootstrap3.client.shared.event.ModalHiddenEvent;
import org.gwtbootstrap3.client.shared.event.ModalHiddenHandler;
import org.gwtbootstrap3.client.shared.event.ModalShownEvent;
import org.gwtbootstrap3.client.shared.event.ModalShownHandler;
import org.gwtbootstrap3.client.ui.Button;
import org.gwtbootstrap3.client.ui.Modal;
import org.gwtbootstrap3.client.ui.ModalBody;
import org.gwtbootstrap3.client.ui.ModalFooter;
import org.gwtbootstrap3.client.ui.constants.ButtonDismiss;
import org.gwtbootstrap3.client.ui.constants.ButtonType;
import org.gwtbootstrap3.client.ui.constants.ModalBackdrop;
import org.uberfire.client.resources.WorkbenchResources;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

@Dependent
public class Bs3Modal
extends Modal {
    private final ModalBody body = (ModalBody)GWT.create(ModalBody.class);
    boolean hasBeenShown;

    public Bs3Modal() {
        this.add((Widget)this.body);
        this.setDataBackdrop(ModalBackdrop.STATIC);
        this.setFade(true);
        this.getElement().setAttribute("role", "dialog");
        this.getElement().setAttribute("tabindex", "-1");
        this.addStyleName(WorkbenchResources.INSTANCE.CSS().modal());
        this.setId(DOM.createUniqueId());
    }

    protected void onAttach() {
        super.onAttach();
        this.initFooter(this.getId());
    }

    private native void initFooter(String var1);

    public void show(final Command afterShown, final Command afterClosed) {
        PortablePreconditions.checkNotNull((String)"afterShown", (Object)afterShown);
        PortablePreconditions.checkNotNull((String)"afterClosed", (Object)afterClosed);
        this.addShownHandler(new ModalShownHandler(){

            public void onShown(ModalShownEvent showEvent) {
                if (afterShown != null) {
                    afterShown.execute();
                }
            }
        });
        this.addHiddenHandler(new ModalHiddenHandler(){

            public void onHidden(ModalHiddenEvent hiddenEvent) {
                if (afterClosed != null) {
                    afterClosed.execute();
                }
            }
        });
        this.show();
    }

    public void show() {
        if (this.hasBeenShown) {
            throw new IllegalStateException("This modal has already been shown. Create a new instance if you want to show another modal.");
        }
        super.show();
    }

    public void setContent(IsWidget content) {
        this.body.clear();
        this.body.add(content);
    }

    protected void addDefaultFooter() {
        Button close = (Button)GWT.create(Button.class);
        close.setText("OK");
        close.setDataDismiss(ButtonDismiss.MODAL);
        close.setType(ButtonType.PRIMARY);
        this.setFooterContent((IsWidget)close);
    }

    public void setModalTitle(String title) {
        this.setTitle(SafeHtmlUtils.htmlEscape((String)title));
    }

    public void setFooterContent(IsWidget content) {
        ModalFooter footer = (ModalFooter)GWT.create(ModalFooter.class);
        this.add((Widget)footer);
        footer.add(content);
    }

    public void setBodyHeight(int height) {
        this.body.setHeight(height + "px");
    }
}

